/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan2;

import java.io.Serializable;
import org.sonar.api.batch.analyzer.AnalyzerContext;
import org.sonar.api.batch.analyzer.issue.AnalyzerIssue;
import org.sonar.api.batch.analyzer.issue.AnalyzerIssueBuilder;
import org.sonar.api.batch.analyzer.issue.internal.DefaultAnalyzerIssue;
import org.sonar.api.batch.analyzer.issue.internal.DefaultAnalyzerIssueBuilder;
import org.sonar.api.batch.analyzer.measure.AnalyzerMeasure;
import org.sonar.api.batch.analyzer.measure.AnalyzerMeasureBuilder;
import org.sonar.api.batch.analyzer.measure.internal.DefaultAnalyzerMeasure;
import org.sonar.api.batch.analyzer.measure.internal.DefaultAnalyzerMeasureBuilder;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.Rules;
import org.sonar.api.config.Settings;
import org.sonar.batch.issue.IssueFilters;
import org.sonar.batch.scan.AnalyzerContextAdaptor;
import org.sonar.batch.scan2.AnalyzerIssueCache;
import org.sonar.batch.scan2.AnalyzerMeasureCache;
import org.sonar.core.component.ComponentKeys;

public class DefaultAnalyzerContext
implements AnalyzerContext {
    private final AnalyzerMeasureCache measureCache;
    private final AnalyzerIssueCache issueCache;
    private final ProjectDefinition def;
    private final Settings settings;
    private final FileSystem fs;
    private final ActiveRules activeRules;
    private final IssueFilters issueFilters;
    private final Rules rules;

    public DefaultAnalyzerContext(ProjectDefinition def, AnalyzerMeasureCache measureCache, AnalyzerIssueCache issueCache, Settings settings, FileSystem fs, ActiveRules activeRules, IssueFilters issueFilters, Rules rules) {
        this.def = def;
        this.measureCache = measureCache;
        this.issueCache = issueCache;
        this.settings = settings;
        this.fs = fs;
        this.activeRules = activeRules;
        this.issueFilters = issueFilters;
        this.rules = rules;
    }

    public Settings settings() {
        return this.settings;
    }

    public FileSystem fileSystem() {
        return this.fs;
    }

    public ActiveRules activeRules() {
        return this.activeRules;
    }

    public <G extends Serializable> AnalyzerMeasureBuilder<G> measureBuilder() {
        return new DefaultAnalyzerMeasureBuilder();
    }

    public AnalyzerMeasure getMeasure(String metricKey) {
        return this.measureCache.byMetric(this.def.getKey(), this.def.getKey(), metricKey);
    }

    public <G extends Serializable> AnalyzerMeasure<G> getMeasure(Metric<G> metric) {
        return this.measureCache.byMetric(this.def.getKey(), this.def.getKey(), metric.key());
    }

    public AnalyzerMeasure getMeasure(InputFile file, String metricKey) {
        return this.measureCache.byMetric(this.def.getKey(), ComponentKeys.createEffectiveKey((String)this.def.getKey(), (InputFile)file), metricKey);
    }

    public <G extends Serializable> AnalyzerMeasure<G> getMeasure(InputFile file, Metric<G> metric) {
        return this.measureCache.byMetric(this.def.getKey(), ComponentKeys.createEffectiveKey((String)this.def.getKey(), (InputFile)file), metric.key());
    }

    public void addMeasure(AnalyzerMeasure<?> measure) {
        if (measure.inputFile() != null) {
            this.measureCache.put(this.def.getKey(), ComponentKeys.createEffectiveKey((String)this.def.getKey(), (InputFile)measure.inputFile()), (DefaultAnalyzerMeasure)measure);
        } else {
            this.measureCache.put(this.def.getKey(), this.def.getKey(), (DefaultAnalyzerMeasure)measure);
        }
    }

    public AnalyzerIssueBuilder issueBuilder() {
        return new DefaultAnalyzerIssueBuilder();
    }

    public boolean addIssue(AnalyzerIssue issue) {
        String resourceKey = issue.inputFile() != null ? ComponentKeys.createEffectiveKey((String)this.def.getKey(), (InputFile)issue.inputFile()) : this.def.getKey();
        if (this.issueFilters.accept(AnalyzerContextAdaptor.toDefaultIssue(this.def.getKey(), resourceKey, issue), null)) {
            this.issueCache.put(this.def.getKey(), resourceKey, (DefaultAnalyzerIssue)issue);
            return true;
        }
        return false;
    }
}

