/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan2;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.sonar.api.batch.analyzer.measure.internal.DefaultAnalyzerMeasure;
import org.sonar.api.batch.analyzer.measure.internal.DefaultAnalyzerMeasureBuilder;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.MetricFinder;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.batch.scan2.AnalyzerMeasureCache;
import org.sonar.core.component.ComponentKeys;

public class DefaultFileLinesContext
implements FileLinesContext {
    private final AnalyzerMeasureCache measureCache;
    private final InputFile inputFile;
    private final Map<String, Map<Integer, Object>> map = Maps.newHashMap();
    private String projectKey;
    private MetricFinder metricFinder;

    public DefaultFileLinesContext(MetricFinder metricFinder, AnalyzerMeasureCache measureCache, String projectKey, InputFile inputFile) {
        this.metricFinder = metricFinder;
        this.projectKey = projectKey;
        Preconditions.checkNotNull((Object)measureCache);
        this.measureCache = measureCache;
        this.inputFile = inputFile;
    }

    public void setIntValue(String metricKey, int line, int value) {
        Preconditions.checkNotNull((Object)metricKey);
        Preconditions.checkArgument((line > 0 ? 1 : 0) != 0);
        this.setValue(metricKey, line, value);
    }

    public Integer getIntValue(String metricKey, int line) {
        Preconditions.checkNotNull((Object)metricKey);
        Preconditions.checkArgument((line > 0 ? 1 : 0) != 0);
        Map lines = this.map.get(metricKey);
        if (lines == null) {
            lines = this.loadData(metricKey, (KeyValueFormat.Converter)KeyValueFormat.newIntegerConverter());
            this.map.put(metricKey, lines);
        }
        return (Integer)lines.get(line);
    }

    public void setStringValue(String metricKey, int line, String value) {
        Preconditions.checkNotNull((Object)metricKey);
        Preconditions.checkArgument((line > 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)value);
        this.setValue(metricKey, line, value);
    }

    public String getStringValue(String metricKey, int line) {
        Preconditions.checkNotNull((Object)metricKey);
        Preconditions.checkArgument((line > 0 ? 1 : 0) != 0);
        Map lines = this.map.get(metricKey);
        if (lines == null) {
            lines = this.loadData(metricKey, (KeyValueFormat.Converter)KeyValueFormat.newStringConverter());
            this.map.put(metricKey, lines);
        }
        return (String)lines.get(line);
    }

    private Map<Integer, Object> getOrCreateLines(String metricKey) {
        HashMap lines = this.map.get(metricKey);
        if (lines == null) {
            lines = Maps.newHashMap();
            this.map.put(metricKey, lines);
        }
        return lines;
    }

    private void setValue(String metricKey, int line, Object value) {
        this.getOrCreateLines(metricKey).put(line, value);
    }

    public void save() {
        for (Map.Entry<String, Map<Integer, Object>> entry : this.map.entrySet()) {
            String metricKey = entry.getKey();
            org.sonar.api.measures.Metric metric = this.metricFinder.findByKey(metricKey);
            if (metric == null) {
                throw new IllegalStateException("Unable to find metric with key: " + metricKey);
            }
            Map<Integer, Object> lines = entry.getValue();
            if (!this.shouldSave(lines)) continue;
            String data = KeyValueFormat.format(lines);
            this.measureCache.put(this.projectKey, ComponentKeys.createEffectiveKey((String)this.projectKey, (InputFile)this.inputFile), new DefaultAnalyzerMeasureBuilder().forMetric((Metric)metric).onFile(this.inputFile).withValue((Serializable)((Object)data)).build());
            entry.setValue((Map<Integer, Object>)ImmutableMap.copyOf(lines));
        }
    }

    private Map loadData(String metricKey, KeyValueFormat.Converter converter) {
        DefaultAnalyzerMeasure<?> measure = this.measureCache.byMetric(this.projectKey, ComponentKeys.createEffectiveKey((String)this.projectKey, (InputFile)this.inputFile), metricKey);
        if (measure == null) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf((Map)KeyValueFormat.parse((String)((String)((Object)measure.value())), (KeyValueFormat.Converter)KeyValueFormat.newIntegerConverter(), (KeyValueFormat.Converter)converter));
    }

    private boolean shouldSave(Map<Integer, Object> lines) {
        return !(lines instanceof ImmutableMap);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("map", this.map).toString();
    }
}

