/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan2;

import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.MetricFinder;
import org.sonar.api.resources.Resource;
import org.sonar.batch.scan.filesystem.InputFileCache;
import org.sonar.batch.scan2.AnalyzerMeasureCache;
import org.sonar.batch.scan2.DefaultFileLinesContext;

public class DefaultFileLinesContextFactory
implements FileLinesContextFactory {
    private final AnalyzerMeasureCache measureCache;
    private final MetricFinder metricFinder;
    private final ProjectDefinition def;
    private InputFileCache fileCache;

    public DefaultFileLinesContextFactory(InputFileCache fileCache, FileSystem fs, MetricFinder metricFinder, AnalyzerMeasureCache measureCache, ProjectDefinition def) {
        this.fileCache = fileCache;
        this.metricFinder = metricFinder;
        this.measureCache = measureCache;
        this.def = def;
    }

    public FileLinesContext createFor(Resource model) {
        throw new UnsupportedOperationException();
    }

    public FileLinesContext createFor(InputFile inputFile) {
        if (this.fileCache.get(this.def.getKey(), inputFile.relativePath()) == null) {
            throw new IllegalStateException("InputFile is not indexed: " + inputFile);
        }
        return new DefaultFileLinesContext(this.metricFinder, this.measureCache, this.def.getKey(), inputFile);
    }
}

