/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.source;

import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.sonar.api.source.Symbol;
import org.sonar.api.source.Symbolizable;
import org.sonar.batch.source.DefaultSymbol;

public class DefaultSymbolTable
implements Symbolizable.SymbolTable {
    private Multimap<Symbol, Integer> referencesBySymbol;

    private DefaultSymbolTable(Multimap<Symbol, Integer> referencesBySymbol) {
        this.referencesBySymbol = referencesBySymbol;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Multimap<Symbol, Integer> getReferencesBySymbol() {
        return this.referencesBySymbol;
    }

    public List<Symbol> symbols() {
        return new ArrayList<Symbol>(this.referencesBySymbol.keySet());
    }

    public List<Integer> references(Symbol symbol) {
        return new ArrayList<Integer>(this.referencesBySymbol.get((Object)symbol));
    }

    public static class Builder
    implements Symbolizable.SymbolTableBuilder {
        private final Multimap<Symbol, Integer> referencesBySymbol = TreeMultimap.create((Comparator)new SymbolComparator(), (Comparator)new ReferenceComparator());

        public Symbol newSymbol(int fromOffset, int toOffset) {
            DefaultSymbol symbol = new DefaultSymbol(fromOffset, toOffset);
            this.referencesBySymbol.put((Object)symbol, (Object)symbol.getDeclarationStartOffset());
            return symbol;
        }

        public void newReference(Symbol symbol, int fromOffset) {
            if (fromOffset >= symbol.getDeclarationStartOffset() && fromOffset < symbol.getDeclarationEndOffset()) {
                throw new UnsupportedOperationException("Cannot add reference (" + fromOffset + ") overlapping " + symbol);
            }
            this.referencesBySymbol.put((Object)symbol, (Object)fromOffset);
        }

        public Symbolizable.SymbolTable build() {
            return new DefaultSymbolTable(this.referencesBySymbol);
        }

        private static class ReferenceComparator
        implements Comparator<Integer>,
        Serializable {
            private ReferenceComparator() {
            }

            @Override
            public int compare(Integer left, Integer right) {
                int result = left != null & right != null ? left - right : (left == null ? -1 : 1);
                return result;
            }
        }

        private static class SymbolComparator
        implements Comparator<Symbol>,
        Serializable {
            private SymbolComparator() {
            }

            @Override
            public int compare(Symbol left, Symbol right) {
                return left.getDeclarationStartOffset() - right.getDeclarationStartOffset();
            }
        }
    }
}

