/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.source;

import com.google.common.collect.Multimap;
import java.util.Collection;
import org.sonar.api.source.Symbol;
import org.sonar.api.source.Symbolizable;
import org.sonar.batch.index.Data;
import org.sonar.batch.source.DefaultSymbolTable;

public class SymbolData
implements Data {
    private static final String FIELD_SEPARATOR = ",";
    private static final String SYMBOL_SEPARATOR = ";";
    private final Symbolizable.SymbolTable symbolTable;

    public SymbolData(Symbolizable.SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
    }

    @Override
    public String writeString() {
        StringBuilder sb = new StringBuilder();
        Multimap<Symbol, Integer> referencesBySymbol = ((DefaultSymbolTable)this.symbolTable).getReferencesBySymbol();
        for (Symbol symbol : ((DefaultSymbolTable)this.symbolTable).getReferencesBySymbol().keySet()) {
            sb.append(symbol.getDeclarationStartOffset()).append(FIELD_SEPARATOR).append(symbol.getDeclarationEndOffset());
            Collection symbolReferences = referencesBySymbol.get((Object)symbol);
            for (Integer symbolReference : symbolReferences) {
                sb.append(FIELD_SEPARATOR).append(symbolReference);
            }
            sb.append(SYMBOL_SEPARATOR);
        }
        return sb.toString();
    }

    @Override
    public void readString(String s) {
        throw new UnsupportedOperationException();
    }
}

