/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.tasks;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.sonar.api.task.TaskComponent;
import org.sonar.api.task.TaskDefinition;
import org.sonar.api.utils.SonarException;

public class Tasks
implements TaskComponent {
    private final SortedMap<String, TaskDefinition> byKey;

    public Tasks(TaskDefinition[] definitions) {
        TreeMap map = Maps.newTreeMap();
        for (TaskDefinition definition : definitions) {
            if (map.containsKey(definition.key())) {
                throw new SonarException("Task '" + definition.key() + "' is declared twice");
            }
            map.put(definition.key(), definition);
        }
        this.byKey = ImmutableSortedMap.copyOf((Map)map);
    }

    public TaskDefinition definition(String taskKey) {
        return (TaskDefinition)this.byKey.get(taskKey);
    }

    public Collection<TaskDefinition> definitions() {
        return this.byKey.values();
    }

    public void start() {
        this.checkDuplicatedClasses();
    }

    private void checkDuplicatedClasses() {
        HashMap byClass = Maps.newHashMap();
        for (TaskDefinition def : this.definitions()) {
            TaskDefinition other = (TaskDefinition)byClass.get(def.taskClass());
            if (other == null) {
                byClass.put(def.taskClass(), def);
                continue;
            }
            throw new SonarException("Task '" + def.taskClass().getName() + "' is defined twice: first by '" + other.key() + "' and then by '" + def.key() + "'");
        }
    }
}

