/*
 * Decompiled with CFR 0.152.
 */
package dev.build;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.sonar:sonar-dev-maven-plugin:0.5", 0);
        this.append(sb, "", 0);
        this.append(sb, "Sonar :: Development Maven Plugin", 0);
        this.append(sb, "Maven plugin for Sonar development environment", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 7 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "analyze".equals(this.goal)) {
            this.append(sb, "sonar-dev:analyze", 0);
            this.append(sb, "Analyzes projects using Sonar.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir (Default: ${basedir})", 2);
                this.append(sb, "The base directory from which to execute the Ant script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "database (Default: derby)", 2);
                this.append(sb, "Database profile: [derby, mssql, mysql, oracle, postgresql].", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcDriver", 2);
                this.append(sb, "Database driver.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcPassword (Default: sonar)", 2);
                this.append(sb, "Database password.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcUrl", 2);
                this.append(sb, "Database URL.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcUsername (Default: sonar)", 2);
                this.append(sb, "Database username.", 3);
                this.append(sb, "", 0);
                this.append(sb, "messageLevel (Default: info)", 2);
                this.append(sb, "The message-level used to tune the verbosity of Ant logging.", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectsDir (Default: ${basedir})", 2);
                this.append(sb, "Directory containing projects.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "sonar-dev:help", 0);
            this.append(sb, "Display help information on sonar-dev-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0sonar-dev:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "start".equals(this.goal)) {
            this.append(sb, "sonar-dev:start", 0);
            this.append(sb, "Start Sonar.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "background (Default: false)", 2);
                this.append(sb, "Set to true to run Sonar in background mode.", 3);
                this.append(sb, "", 0);
                this.append(sb, "basedir (Default: ${basedir})", 2);
                this.append(sb, "The base directory from which to execute the Ant script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "clean (Default: true)", 2);
                this.append(sb, "Set to false to prevent clean installation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "configBackup", 2);
                this.append(sb, "File from where Sonar configuration should be restored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "database (Default: derby)", 2);
                this.append(sb, "Database profile: [derby, mssql, mysql, oracle, postgresql].", 3);
                this.append(sb, "", 0);
                this.append(sb, "dropDatabase (Default: false)", 2);
                this.append(sb, "Set to true to drop database.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extensionsDir (Default: ${project.build.directory}/extensions)", 2);
                this.append(sb, "Directory from where extensions should be copied.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcDriver", 2);
                this.append(sb, "Database driver.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcPassword (Default: sonar)", 2);
                this.append(sb, "Database password.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcRootPassword", 2);
                this.append(sb, "Database root password. Used when dropDatabase is true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcRootUrl", 2);
                this.append(sb, "Database root URL. Used when dropDatabase is true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcRootUsername", 2);
                this.append(sb, "Database root username. Used when dropDatabase is true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcUrl", 2);
                this.append(sb, "Database URL.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcUsername (Default: sonar)", 2);
                this.append(sb, "Database username.", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository", 2);
                this.append(sb, "Local Maven repository.", 3);
                this.append(sb, "", 0);
                this.append(sb, "messageLevel (Default: info)", 2);
                this.append(sb, "The message-level used to tune the verbosity of Ant logging.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifact (Default: ${project.build.directory}/${project.build.finalName}.jar)", 2);
                this.append(sb, "Plugin to install.", 3);
                this.append(sb, "", 0);
                this.append(sb, "runtimeVersion (Default: 2.2)", 2);
                this.append(sb, "Sonar version.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "start-war".equals(this.goal)) {
            this.append(sb, "sonar-dev:start-war", 0);
            this.append(sb, "Starts Sonar WAR.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "background (Default: false)", 2);
                this.append(sb, "Set to true to run Sonar in background mode.", 3);
                this.append(sb, "", 0);
                this.append(sb, "basedir (Default: ${basedir})", 2);
                this.append(sb, "The base directory from which to execute the Ant script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "clean (Default: true)", 2);
                this.append(sb, "Set to false to prevent clean installation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "configBackup", 2);
                this.append(sb, "File from where Sonar configuration should be restored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "database (Default: derby)", 2);
                this.append(sb, "Database profile: [derby, mssql, mysql, oracle, postgresql].", 3);
                this.append(sb, "", 0);
                this.append(sb, "dropDatabase (Default: false)", 2);
                this.append(sb, "Set to true to drop database.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extensionsDir (Default: ${project.build.directory}/extensions)", 2);
                this.append(sb, "Directory from where extensions should be copied.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcDriver", 2);
                this.append(sb, "Database driver.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcPassword (Default: sonar)", 2);
                this.append(sb, "Database password.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcRootPassword", 2);
                this.append(sb, "Database root password. Used when dropDatabase is true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcRootUrl", 2);
                this.append(sb, "Database root URL. Used when dropDatabase is true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcRootUsername", 2);
                this.append(sb, "Database root username. Used when dropDatabase is true.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcUrl", 2);
                this.append(sb, "Database URL.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcUsername (Default: sonar)", 2);
                this.append(sb, "Database username.", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository", 2);
                this.append(sb, "Local Maven repository.", 3);
                this.append(sb, "", 0);
                this.append(sb, "messageLevel (Default: info)", 2);
                this.append(sb, "The message-level used to tune the verbosity of Ant logging.", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifact (Default: ${project.build.directory}/${project.build.finalName}.jar)", 2);
                this.append(sb, "Plugin to install.", 3);
                this.append(sb, "", 0);
                this.append(sb, "runtimeVersion (Default: 2.2)", 2);
                this.append(sb, "Sonar version.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "stop".equals(this.goal)) {
            this.append(sb, "sonar-dev:stop", 0);
            this.append(sb, "Stop Sonar.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir (Default: ${basedir})", 2);
                this.append(sb, "The base directory from which to execute the Ant script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "messageLevel (Default: info)", 2);
                this.append(sb, "The message-level used to tune the verbosity of Ant logging.", 3);
                this.append(sb, "", 0);
                this.append(sb, "runtimeVersion (Default: 2.2)", 2);
                this.append(sb, "Sonar version.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "stop-war".equals(this.goal)) {
            this.append(sb, "sonar-dev:stop-war", 0);
            this.append(sb, "Stops Sonar WAR.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir (Default: ${basedir})", 2);
                this.append(sb, "The base directory from which to execute the Ant script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "messageLevel (Default: info)", 2);
                this.append(sb, "The message-level used to tune the verbosity of Ant logging.", 3);
                this.append(sb, "", 0);
                this.append(sb, "runtimeVersion (Default: 2.2)", 2);
                this.append(sb, "Sonar version.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "trim".equals(this.goal)) {
            this.append(sb, "sonar-dev:trim", 0);
            this.append(sb, "(no description available)", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "directory", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "List of ant-style patterns. If this is not specified, allfiles in the project source directories are included.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Specifies the encoding of the source files.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

