/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.java.language;

public class ArgumentAndReturnType {

  private final JavaType javaType;
  private final String classCanonicalName;
  private final boolean isArray;

  public ArgumentAndReturnType(JavaType javaType, boolean isArray) {
    this(javaType, null, isArray);
  }

  public ArgumentAndReturnType(String classCanonicalName, boolean isArray) {
    this(JavaType.OBJECT, classCanonicalName, isArray);
  }

  ArgumentAndReturnType(JavaType javaType, String classCanonicalName, boolean isArray) {
    if (javaType == JavaType.OBJECT && (classCanonicalName == null || classCanonicalName.equals(""))) {
      throw new IllegalStateException("With an Object JavaType, this is mandatory to specify the canonical name of the class.");
    }
    this.javaType = javaType;
    this.classCanonicalName = classCanonicalName;
    this.isArray = isArray;
  }

  public ArgumentAndReturnType(ArgumentAndReturnType argumentAndReturnType) {
    this(argumentAndReturnType.javaType, argumentAndReturnType.classCanonicalName, argumentAndReturnType.isArray);
  }

  public boolean isVoid() {
    return javaType == JavaType.VOID;
  }

  public JavaType getJavaType() {
    return javaType;
  }

  public String getClassCanonicalName() {
    return classCanonicalName;
  }

  public boolean isArray() {
    return isArray;
  }

  public boolean isOject() {
    return javaType == JavaType.OBJECT;
  }
}
