/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.upgrade.impl.operations;

import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.upgrade.UpgradeOperation;
import org.craftercms.commons.upgrade.exception.UpgradeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public abstract class AbstractUpgradeOperation<T>
implements UpgradeOperation<T>,
ApplicationContextAware {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String currentVersion;
    protected String nextVersion;
    protected boolean enabled = true;
    protected ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void init(String currentVersion, String nextVersion, HierarchicalConfiguration config) throws ConfigurationException {
        this.currentVersion = currentVersion;
        this.nextVersion = nextVersion;
        this.doInit(config);
    }

    protected void doInit(HierarchicalConfiguration<?> config) throws ConfigurationException {
    }

    @Override
    public void execute(T target) throws UpgradeException {
        if (!this.enabled) {
            this.logger.info("This operation is disabled, skipping execution");
            return;
        }
        this.logger.debug("Starting execution for target {}", target);
        try {
            this.doExecute(target);
        }
        catch (Exception e) {
            throw new UpgradeException("Error executing upgrade operation " + this.getClass(), e);
        }
        finally {
            this.logger.debug("Execution completed for target {}", target);
        }
    }

    protected abstract void doExecute(T var1) throws Exception;

    protected Resource loadResource(String path) {
        return this.applicationContext.getResource(path);
    }
}

