/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.upgrade.impl.pipeline;

import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.config.YamlConfiguration;
import org.craftercms.commons.upgrade.UpgradeOperation;
import org.craftercms.commons.upgrade.UpgradePipeline;
import org.craftercms.commons.upgrade.UpgradePipelineFactory;
import org.craftercms.commons.upgrade.VersionProvider;
import org.craftercms.commons.upgrade.exception.UpgradeException;
import org.craftercms.commons.upgrade.impl.operations.UpdateVersionUpgradeOperation;
import org.craftercms.commons.upgrade.impl.pipeline.DefaultUpgradePipelineImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class DefaultUpgradePipelineFactoryImpl<T>
implements UpgradePipelineFactory<T>,
ApplicationContextAware {
    public static final String DEFAULT_PIPELINE_PREFIX = "pipelines.";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected VersionProvider versionProvider;
    protected Resource configurationFile;
    protected String pipelinePrefix = "pipelines.";
    protected String pipelineName;
    protected boolean updateVersion = true;
    protected ApplicationContext applicationContext;

    public DefaultUpgradePipelineFactoryImpl(String pipelineName, Resource configurationFile, VersionProvider versionProvider) {
        this.pipelineName = pipelineName;
        this.configurationFile = configurationFile;
        this.versionProvider = versionProvider;
    }

    public void setPipelinePrefix(String pipelinePrefix) {
        this.pipelinePrefix = pipelinePrefix;
    }

    public void setUpdateVersion(boolean updateVersion) {
        this.updateVersion = updateVersion;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected HierarchicalConfiguration loadUpgradeConfiguration() throws UpgradeException {
        YamlConfiguration configuration = new YamlConfiguration();
        try (InputStream is = this.configurationFile.getInputStream();){
            configuration.read(is);
        }
        catch (Exception e) {
            throw new UpgradeException("Error reading configuration file", e);
        }
        return configuration;
    }

    protected UpgradePipeline createPipeline(String name, List<UpgradeOperation<T>> operations) {
        this.logger.debug("Creating pipeline instance for '{}'", (Object)name);
        return new DefaultUpgradePipelineImpl<T>(name, operations);
    }

    @Override
    public UpgradePipeline getPipeline(T target) throws UpgradeException, ConfigurationException {
        this.logger.debug("Building pipeline for target '{}'", target);
        String currentVersion = this.versionProvider.getVersion(target);
        if ("SKIP".equals(currentVersion)) {
            return new DefaultUpgradePipelineImpl(this.pipelineName, Collections.emptyList());
        }
        LinkedList<UpgradeOperation<T>> operations = new LinkedList<UpgradeOperation<T>>();
        HierarchicalConfiguration config = this.loadUpgradeConfiguration();
        List pipeline = config.configurationsAt(this.pipelinePrefix + this.pipelineName);
        String nextVersion = currentVersion;
        for (HierarchicalConfiguration release : pipeline) {
            String sourceVersion = release.getString("currentVersion");
            String targetVersion = release.getString("nextVersion");
            if (sourceVersion.equals(nextVersion)) {
                this.logger.debug("Adding version '{}' to pipeline '{}'", (Object)sourceVersion, (Object)this.pipelineName);
                List operationsConfig = release.configurationsAt("operations");
                for (HierarchicalConfiguration operationConfig : operationsConfig) {
                    UpgradeOperation operation = (UpgradeOperation)this.applicationContext.getBean(operationConfig.getString("type"), UpgradeOperation.class);
                    operation.init(sourceVersion, targetVersion, operationConfig);
                    operations.add(operation);
                }
                nextVersion = targetVersion;
                continue;
            }
            this.logger.debug("Skipping version '{}' already applied", (Object)sourceVersion);
        }
        if (!CollectionUtils.isEmpty(operations) && this.updateVersion) {
            this.logger.debug("Adding upgrade version operation to pipeline '{}'", (Object)this.pipelineName);
            UpdateVersionUpgradeOperation updateOp = new UpdateVersionUpgradeOperation(this.versionProvider);
            updateOp.init(currentVersion, nextVersion, config);
            operations.add(updateOp);
        } else {
            this.logger.debug("Skipping upgrade version operation for pipeline '{}'", (Object)this.pipelineName);
        }
        return this.createPipeline(this.pipelineName, operations);
    }
}

