/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.upgrade.impl.providers;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.craftercms.commons.upgrade.impl.providers.AbstractVersionProvider;

public abstract class AbstractFileVersionProvider
extends AbstractVersionProvider {
    protected Path getFile(Object target) {
        if (target instanceof String) {
            return Paths.get((String)target, new String[0]);
        }
        if (target instanceof File) {
            return ((File)target).toPath();
        }
        if (target instanceof Path) {
            return (Path)target;
        }
        throw new IllegalArgumentException("Target can't be converted to Path: " + target);
    }

    @Override
    protected String doGetVersion(Object target) throws Exception {
        Path file = this.getFile(target);
        return this.readVersionFromFile(file);
    }

    @Override
    protected void doSetVersion(Object target, String version) throws Exception {
        Path file = this.getFile(target);
        this.writeVersionToFile(file, version);
    }

    protected abstract String readVersionFromFile(Path var1) throws Exception;

    protected abstract void writeVersionToFile(Path var1, String var2) throws Exception;
}

