/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.upgrade.impl.providers;

import org.craftercms.commons.upgrade.VersionProvider;
import org.craftercms.commons.upgrade.exception.UpgradeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractVersionProvider
implements VersionProvider {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String defaultValue = "SKIP";

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public String getVersion(Object target) throws UpgradeException {
        this.logger.debug("Getting current version for {}", target);
        try {
            String currentValue = this.doGetVersion(target);
            this.logger.debug("Found version {} for {}", (Object)currentValue, target);
            if (StringUtils.isEmpty((Object)currentValue)) {
                currentValue = this.defaultValue;
            }
            return currentValue;
        }
        catch (Exception e) {
            throw new UpgradeException("Error getting current version for " + target, e);
        }
    }

    protected abstract String doGetVersion(Object var1) throws Exception;

    @Override
    public void setVersion(Object target, String version) throws UpgradeException {
        this.logger.debug("Updating current version for {} to {}", target, (Object)version);
        try {
            this.doSetVersion(target, version);
            this.logger.debug("Version successfully updated for {}", target);
        }
        catch (Exception e) {
            throw new UpgradeException("Error updating version for " + target, e);
        }
    }

    protected abstract void doSetVersion(Object var1, String var2) throws Exception;
}

