/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.gradle.plugins.locc;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.cthing.gradle.plugins.locc.CountsCache;
import org.cthing.gradle.plugins.locc.LoccExtension;
import org.cthing.gradle.plugins.locc.LoccReports;
import org.cthing.gradle.plugins.locc.reports.LoccReport;
import org.cthing.locc4j.Counts;
import org.cthing.locc4j.FileCounter;
import org.cthing.locc4j.Language;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;

public class LoccTask
extends SourceTask
implements Reporting<LoccReports> {
    private final Property<Boolean> countDocStrings;
    private final LoccReports reports;

    public LoccTask() {
        Project project = this.getProject();
        LoccExtension extension = (LoccExtension)project.getExtensions().getByType(LoccExtension.class);
        this.countDocStrings = project.getObjects().property(Boolean.class).convention(extension.getCountDocStrings());
        DirectoryProperty reportsDir = project.getObjects().directoryProperty().convention((Provider)extension.getReportsDir());
        this.reports = new LoccReports((Task)this, reportsDir);
    }

    @Input
    @Optional
    public Property<Boolean> getCountDocStrings() {
        return this.countDocStrings;
    }

    public void addExtension(String fileExtension, Language language) {
        Language.addExtension((String)fileExtension, (Language)language);
    }

    public void removeExtension(String fileExtension) {
        Language.removeExtension((String)fileExtension);
    }

    @Nested
    public LoccReports getReports() {
        return this.reports;
    }

    public LoccReports reports(Action<? super LoccReports> configureAction) {
        configureAction.execute((Object)this.reports);
        return this.reports;
    }

    public LoccReports reports(Closure closure) {
        Closure cl = (Closure)closure.clone();
        cl.setResolveStrategy(1);
        cl.setDelegate((Object)this.reports);
        cl.call((Object)this.reports);
        return this.reports;
    }

    @TaskAction
    public void count() {
        List<Path> files = this.getSource().getFiles().stream().map(File::toPath).toList();
        FileCounter counter = new FileCounter();
        counter.countDocStrings(((Boolean)this.countDocStrings.get()).booleanValue());
        try {
            Map counts = counter.count(files);
            this.generateReports(counts);
        }
        catch (IOException ex) {
            throw new TaskExecutionException((Task)this, (Throwable)ex);
        }
    }

    private void generateReports(Map<Path, Map<Language, Counts>> counts) {
        CountsCache countsCache = new CountsCache(counts);
        this.generateReport(this.reports.getXml(), countsCache);
        this.generateReport(this.reports.getHtml(), countsCache);
        this.generateReport(this.reports.getYaml(), countsCache);
        this.generateReport(this.reports.getJson(), countsCache);
        this.generateReport(this.reports.getCsv(), countsCache);
        this.generateReport(this.reports.getText(), countsCache);
    }

    private void generateReport(LoccReport report, CountsCache countsCache) {
        if (((Boolean)report.getRequired().get()).booleanValue()) {
            report.generateReport(countsCache);
        }
    }
}

