/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.gradle.plugins.locc.reports;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import java.io.File;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.cthing.gradle.plugins.locc.reports.LoccReport;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.reporting.Report;

abstract class AbstractLoccReport
extends GroovyObjectSupport
implements LoccReport {
    protected static final String REPORT_BASE_NAME = "locc";
    protected final Task task;
    private final String name;
    private final String displayName;
    private final RegularFileProperty destination;
    private final Path rootProjectPath;
    private final Property<Boolean> required;
    private final Property<Boolean> showRelativePaths;

    protected AbstractLoccReport(Task task, String name, String displayName, boolean required) {
        this.task = task;
        this.name = name;
        this.displayName = displayName;
        this.rootProjectPath = task.getProject().getRootProject().getProjectDir().toPath();
        ObjectFactory objects = task.getProject().getObjects();
        this.destination = objects.fileProperty();
        this.required = objects.property(Boolean.class).convention((Object)required);
        this.showRelativePaths = objects.property(Boolean.class).convention((Object)Boolean.TRUE);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Report.OutputType getOutputType() {
        return Report.OutputType.FILE;
    }

    public Property<Boolean> getRequired() {
        return this.required;
    }

    @Override
    public Property<Boolean> getShowRelativePaths() {
        return this.showRelativePaths;
    }

    public RegularFileProperty getOutputLocation() {
        return this.destination;
    }

    @Deprecated
    public void setDestination(File file) {
        this.destination.set(file);
    }

    void setRequired(boolean required) {
        this.required.set((Object)required);
    }

    void setShowRelativePaths(boolean relative) {
        this.showRelativePaths.set((Object)relative);
    }

    public Report configure(Closure closure) {
        Closure cl = (Closure)closure.clone();
        cl.setResolveStrategy(1);
        cl.setDelegate((Object)this);
        cl.call((Object)this);
        return this;
    }

    protected String timestamp() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX", Locale.US).format(new Date());
    }

    protected Path preparePathname(Path pathname) {
        if (((Boolean)this.showRelativePaths.get()).booleanValue()) {
            return this.rootProjectPath.relativize(pathname);
        }
        return pathname;
    }
}

