/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.gradle.plugins.locc.reports;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import javax.inject.Inject;
import org.cthing.escapers.CsvEscaper;
import org.cthing.gradle.plugins.locc.CountsCache;
import org.cthing.gradle.plugins.locc.reports.AbstractLoccReport;
import org.cthing.locc4j.Counts;
import org.cthing.locc4j.Language;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.TaskExecutionException;
import org.jspecify.annotations.Nullable;

public final class CsvReport
extends AbstractLoccReport {
    @Inject
    public CsvReport(Task task, DirectoryProperty reportsDir) {
        super(task, "csv", "Report in CSV format", false);
        this.getOutputLocation().value(reportsDir.file("locc.csv"));
    }

    @Override
    public void generateReport(CountsCache countsCache) {
        Counts totalCounts = countsCache.getTotalCounts();
        File destination = (File)this.getOutputLocation().getAsFile().get();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(destination.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            this.writeln(writer, "ID,Name,Description,Total Lines,Code Lines,Comment Lines,Blank Lines");
            this.writeln(writer, String.format("ALL,All,All languages,%d,%d,%d,%d", totalCounts.getTotalLines(), totalCounts.getCodeLines(), totalCounts.getCommentLines(), totalCounts.getBlankLines()));
            Map<Language, Counts> langCounts = countsCache.getLanguageCounts();
            ArrayList<Language> languages = new ArrayList<Language>(langCounts.keySet());
            languages.sort(Comparator.comparing(Language::getDisplayName));
            for (Language language : languages) {
                Counts counts = langCounts.get(language);
                this.writeln(writer, String.format("%s,%s,%s,%d,%d,%d,%d", CsvReport.escape(language.name()), CsvReport.escape(language.getDisplayName()), CsvReport.escape(language.getDescription()), counts.getTotalLines(), counts.getCodeLines(), counts.getCommentLines(), counts.getBlankLines()));
            }
        }
        catch (IOException ex) {
            throw new TaskExecutionException(this.task, (Throwable)ex);
        }
    }

    private void writeln(Writer writer, String str) throws IOException {
        writer.write(str);
        writer.write("\r\n");
    }

    static String escape(@Nullable String str) {
        String escaped = CsvEscaper.escape((CharSequence)str);
        return escaped == null ? "" : escaped;
    }
}

