/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.gradle.plugins.locc.reports;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.cthing.escapers.HtmlEscaper;
import org.cthing.gradle.plugins.locc.CountsCache;
import org.cthing.gradle.plugins.locc.reports.AbstractLoccReport;
import org.cthing.locc4j.Counts;
import org.cthing.locc4j.Language;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.TaskExecutionException;

public final class HtmlReport
extends AbstractLoccReport {
    @Inject
    public HtmlReport(Task task, DirectoryProperty reportsDir) {
        super(task, "html", "Report in HTML format", true);
        this.getOutputLocation().value(reportsDir.file("locc.html"));
    }

    @Override
    public void generateReport(CountsCache countsCache) {
        File destination = (File)this.getOutputLocation().getAsFile().get();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(destination.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            this.writeDocumentStart(writer);
            this.writeHead(writer);
            this.writeBodyStart(writer);
            this.writeSummary(writer, countsCache);
            this.writeLanguages(writer, countsCache);
            this.writeFiles(writer, countsCache);
            this.writeBodyEnd(writer);
            this.writeDocumentEnd(writer);
        }
        catch (IOException ex) {
            throw new TaskExecutionException(this.task, (Throwable)ex);
        }
    }

    private void writeDocumentStart(Writer writer) throws IOException {
        writer.write("<!DOCTYPE html>\n<html lang=\"en\">\n");
    }

    private void writeDocumentEnd(Writer writer) throws IOException {
        writer.write("</html>\n");
    }

    private void writeHead(Writer writer) throws IOException {
        writer.write("    <head>\n        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>\n        <title>Line Count Report For %s</title>\n        <style>\n            body {\n                margin: 40px;\n                padding: 0;\n                font-family: sans-serif;\n            }\n            table {\n                border: 1px solid #C3C3C3;\n                border-collapse: collapse;\n            }\n            td, th {\n                border: 1px solid #C3C3C3;\n                padding: 5px 15px 5px 15px;\n            }\n            .CountCell {\n                text-align: right;\n            }\n            .TotalCell {\n                font-weight: bold;\n            }\n            .Unrecognized {\n                color: #DC0000;\n            }\n            a:link {\n                text-decoration: none;\n            }\n            a:visited {\n                text-decoration: none;\n            }\n            a:hover {\n                text-decoration: none;\n            }\n            a:active {\n                text-decoration: none;\n            }\n        </style>\n    </head>\n".formatted(this.task.getProject().getName()));
    }

    private void writeBodyStart(Writer writer) throws IOException {
        writer.write("    <body>\n        <h1>Line Count Report For %s</h1>\n".formatted(HtmlEscaper.escape((CharSequence)this.task.getProject().getName(), (HtmlEscaper.Option[])new HtmlEscaper.Option[0])));
    }

    private void writeBodyEnd(Writer writer) throws IOException {
        writer.write("    </body>\n");
    }

    private void writeSummary(Writer writer, CountsCache countsCache) throws IOException {
        Counts totalCounts = countsCache.getTotalCounts();
        Set<Language> languages = countsCache.getLanguages();
        writer.write("\n        <h2>Summary</h2>\n        <table>\n            <tbody>\n                <tr>\n                    <td>Project</td>\n                    <td>%s</td>\n                </tr>\n                <tr>\n                    <td>Version</td>\n                    <td>%s</td>\n                </tr>\n                <tr>\n                    <td>Report date</td>\n                    <td>%s</td>\n                </tr>\n                <tr>\n                    <td>Number of files</td>\n                    <td>%d</td>\n                </tr>\n                <tr>\n                    <td>Number of languages</td>\n                    <td>%d</td>\n                </tr>\n                <tr>\n                    <td>Unrecognized files</td>\n                    <td>%d</td>\n                </tr>\n                <tr>\n                    <td>Total lines</td>\n                    <td>%d</td>\n                </tr>\n                <tr>\n                    <td>Code lines</td>\n                    <td>%d</td>\n                </tr>\n                <tr>\n                    <td>Comment lines</td>\n                    <td>%d</td>\n                </tr>\n                <tr>\n                    <td>Blank lines</td>\n                    <td>%d</td>\n                </tr>\n            </tbody>\n        </table>\n".formatted(HtmlEscaper.escape((CharSequence)this.task.getProject().getName(), (HtmlEscaper.Option[])new HtmlEscaper.Option[0]), HtmlEscaper.escape((CharSequence)this.task.getProject().getVersion().toString(), (HtmlEscaper.Option[])new HtmlEscaper.Option[0]), HtmlEscaper.escape((CharSequence)this.timestamp(), (HtmlEscaper.Option[])new HtmlEscaper.Option[0]), countsCache.getPathCounts().size(), languages.size(), countsCache.getUnrecognized().size(), totalCounts.getTotalLines(), totalCounts.getCodeLines(), totalCounts.getCommentLines(), totalCounts.getBlankLines()));
    }

    private void writeLanguages(Writer writer, CountsCache countsCache) throws IOException {
        writer.write("\n        <h2>Line Count by Language</h2>\n        <table>\n            <thead>\n                <tr>\n                    <th>Name</th>\n                    <th>Description</th>\n                    <th class=\"CountCell\">Total Lines</th>\n                    <th class=\"CountCell\">Code Lines</th>\n                    <th class=\"CountCell\">Comment Lines</th>\n                    <th class=\"CountCell\">Blank Lines</th>\n                </tr>\n            </thead>\n            <tbody>\n");
        Map<Language, Counts> langCounts = countsCache.getLanguageCounts();
        ArrayList<Language> sortedLanguages = new ArrayList<Language>(langCounts.keySet());
        sortedLanguages.sort(Comparator.comparing(Language::getDisplayName));
        for (Language language : sortedLanguages) {
            Counts counts = langCounts.get(language);
            String description = language.getDescription();
            if (description == null) {
                description = "";
            } else {
                description = HtmlEscaper.escape((CharSequence)description, (HtmlEscaper.Option[])new HtmlEscaper.Option[0]);
                String website = language.getWebsite();
                if (website != null) {
                    description = String.format("<a href=\"%s\">%s</a>", website, description);
                }
            }
            writer.write("                <tr>\n                    <td>%s</td>\n                    <td>%s</td>\n                    <td class=\"CountCell\">%d</td>\n                    <td class=\"CountCell\">%d</td>\n                    <td class=\"CountCell\">%d</td>\n                    <td class=\"CountCell\">%d</td>\n                </tr>\n".formatted(HtmlEscaper.escape((CharSequence)language.getDisplayName(), (HtmlEscaper.Option[])new HtmlEscaper.Option[0]), description, counts.getTotalLines(), counts.getCodeLines(), counts.getCommentLines(), counts.getBlankLines()));
        }
        Counts totalCounts = countsCache.getTotalCounts();
        writer.write("                <tr>\n                    <td class=\"TotalCell\">Total</td>\n                    <td></td>\n                    <td class=\"TotalCell CountCell\">%d</td>\n                    <td class=\"TotalCell CountCell\">%d</td>\n                    <td class=\"TotalCell CountCell\">%d</td>\n                    <td class=\"TotalCell CountCell\">%d</td>\n                </tr>\n".formatted(totalCounts.getTotalLines(), totalCounts.getCodeLines(), totalCounts.getCommentLines(), totalCounts.getBlankLines()));
        writer.write("            </tbody>\n        </table>\n");
    }

    private void writeFiles(Writer writer, CountsCache countsCache) throws IOException {
        writer.write("\n        <h2>Line Count by File</h2>\n        <table>\n            <thead>\n                <tr>\n                    <th>Pathname</th>\n                    <th class=\"CountCell\">Total Lines</th>\n                    <th class=\"CountCell\">Code Lines</th>\n                    <th class=\"CountCell\">Comment Lines</th>\n                    <th class=\"CountCell\">Blank Lines</th>\n                    <th>Languages</th>\n                </tr>\n            </thead>\n            <tbody>\n");
        Map<Path, Counts> pathTotals = countsCache.getFileCounts();
        Set<Path> unrecognized = countsCache.getUnrecognized();
        ArrayList<Path> paths = new ArrayList<Path>(countsCache.getPathCounts().keySet());
        paths.sort(Path::compareTo);
        for (Path path : paths) {
            Counts counts = pathTotals.getOrDefault(path, Counts.ZERO);
            ArrayList<Language> sortedLanguages = new ArrayList<Language>(countsCache.getPathCounts().get(path).keySet());
            sortedLanguages.sort(Comparator.comparing(Language::getDisplayName));
            String unrecognizedClass = "";
            if (unrecognized.contains(path)) {
                unrecognizedClass = " class=\"Unrecognized\"";
            }
            writer.write("                <tr>\n                    <td%s>%s</td>\n                    <td class=\"CountCell\">%d</td>\n                    <td class=\"CountCell\">%d</td>\n                    <td class=\"CountCell\">%d</td>\n                    <td class=\"CountCell\">%d</td>\n                    <td>%s</td>\n                </tr>\n".formatted(unrecognizedClass, HtmlEscaper.escape((CharSequence)this.preparePathname(path).toString(), (HtmlEscaper.Option[])new HtmlEscaper.Option[0]), counts.getTotalLines(), counts.getCodeLines(), counts.getCommentLines(), counts.getBlankLines(), HtmlEscaper.escape((CharSequence)sortedLanguages.stream().map(Language::getDisplayName).collect(Collectors.joining(", ")), (HtmlEscaper.Option[])new HtmlEscaper.Option[0])));
        }
        Counts totalCounts = countsCache.getTotalCounts();
        writer.write("                <tr>\n                    <td class=\"TotalCell\">Total</td>\n                    <td class=\"TotalCell CountCell\">%d</td>\n                    <td class=\"TotalCell CountCell\">%d</td>\n                    <td class=\"TotalCell CountCell\">%d</td>\n                    <td class=\"TotalCell CountCell\">%d</td>\n                    <td></td>\n                </tr>\n".formatted(totalCounts.getTotalLines(), totalCounts.getCodeLines(), totalCounts.getCommentLines(), totalCounts.getBlankLines()));
        writer.write("            </tbody>\n        </table>\n");
    }
}

