/*
 * Decompiled with CFR 0.152.
 */
package org.cthing.gradle.plugins.locc.reports;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.cthing.escapers.YamlEscaper;
import org.cthing.gradle.plugins.locc.CountsCache;
import org.cthing.gradle.plugins.locc.reports.AbstractLoccReport;
import org.cthing.locc4j.Counts;
import org.cthing.locc4j.Language;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.TaskExecutionException;
import org.jspecify.annotations.Nullable;

public final class YamlReport
extends AbstractLoccReport {
    private static final int FORMAT_VERSION = 1;
    private static final String INDENT_4 = "    ";
    private static final String INDENT_8 = "        ";

    @Inject
    public YamlReport(Task task, DirectoryProperty reportsDir) {
        super(task, "yaml", "Report in YAML format", false);
        this.getOutputLocation().value(reportsDir.file("locc.yaml"));
    }

    @Override
    public void generateReport(CountsCache countsCache) {
        Counts totalCounts = countsCache.getTotalCounts();
        Set<Language> languages = countsCache.getLanguages();
        File destination = (File)this.getOutputLocation().getAsFile().get();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(destination.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            this.writeln(writer, "---");
            this.writeln(writer, "formatVersion: ", 1);
            this.writeln(writer, "date: ", this.timestamp());
            this.writeln(writer, "projectName: ", this.task.getProject().getName());
            this.writeln(writer, "projectVersion: ", this.task.getProject().getVersion().toString());
            this.writeln(writer, "numFiles: ", countsCache.getPathCounts().size());
            this.writeln(writer, "numUnrecognized: ", countsCache.getUnrecognized().size());
            this.writeln(writer, "numLanguages: ", languages.size());
            this.writeCounts(writer, null, totalCounts);
            this.writeLanguages(writer, countsCache);
            this.writeFiles(writer, countsCache);
            this.writeln(writer, "...");
        }
        catch (IOException ex) {
            throw new TaskExecutionException(this.task, (Throwable)ex);
        }
    }

    private void writeLanguages(BufferedWriter writer, CountsCache countsCache) throws IOException {
        this.writeln(writer, "languages:");
        Map<Language, Counts> langCounts = countsCache.getLanguageCounts();
        ArrayList<Language> languages = new ArrayList<Language>(langCounts.keySet());
        languages.sort(Comparator.comparing(Language::getDisplayName));
        for (Language language : languages) {
            this.writeln(writer, "  - name: ", language.name());
            this.writeln(writer, "    displayName: ", language.getDisplayName());
            this.writeln(writer, "    description: ", language.getDescription());
            this.writeln(writer, "    website: ", language.getWebsite());
            this.writeCounts(writer, INDENT_4, langCounts.get(language));
        }
    }

    private void writeFiles(BufferedWriter writer, CountsCache countsCache) throws IOException {
        this.writeln(writer, "files:");
        Map<Path, Counts> pathTotals = countsCache.getFileCounts();
        Set<Path> unrecognized = countsCache.getUnrecognized();
        ArrayList<Path> paths = new ArrayList<Path>(countsCache.getPathCounts().keySet());
        paths.sort(Path::compareTo);
        for (Path path : paths) {
            Map<Language, Counts> langCounts = countsCache.getPathCounts().get(path);
            this.writeln(writer, "  - pathname: ", this.preparePathname(path).toString());
            this.writeln(writer, "    numLanguages: ", langCounts.size());
            if (unrecognized.contains(path)) {
                this.writeln(writer, "    unrecognized: ", "true");
            }
            this.writeCounts(writer, INDENT_4, pathTotals.getOrDefault(path, Counts.ZERO));
            ArrayList<Language> languages = new ArrayList<Language>(langCounts.keySet());
            if (languages.isEmpty()) {
                this.writeln(writer, "    languages: []");
                continue;
            }
            this.writeln(writer, "    languages:");
            languages.sort(Comparator.comparing(Language::getDisplayName));
            for (Language language : languages) {
                this.writeln(writer, "      - name: ", language.name());
                this.writeCounts(writer, INDENT_8, langCounts.get(language));
            }
        }
    }

    private void writeCounts(BufferedWriter writer, @Nullable String indent, Counts counts) throws IOException {
        this.writeln(writer, indent, "totalLines: ", counts.getTotalLines());
        this.writeln(writer, indent, "codeLines: ", counts.getCodeLines());
        this.writeln(writer, indent, "commentLines: ", counts.getCommentLines());
        this.writeln(writer, indent, "blankLines: ", counts.getBlankLines());
    }

    private void writeln(BufferedWriter writer, String str) throws IOException {
        writer.write(str);
        writer.newLine();
    }

    private void writeln(BufferedWriter writer, String str, @Nullable String val) throws IOException {
        if (val != null) {
            writer.write(str);
            YamlEscaper.escape((CharSequence)val, (Writer)writer, (YamlEscaper.Option[])new YamlEscaper.Option[0]);
            writer.newLine();
        }
    }

    private void writeln(BufferedWriter writer, String str, int val) throws IOException {
        this.writeln(writer, null, str, val);
    }

    private void writeln(BufferedWriter writer, @Nullable String indent, String str, int val) throws IOException {
        if (indent != null) {
            writer.write(indent);
        }
        writer.write(str);
        writer.write(Integer.toString(val, 10));
        writer.newLine();
    }
}

