/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.mojo;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.dbunit.ant.Operation;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.mojo.AbstractDbUnitMojo;

public class OperationMojo
extends AbstractDbUnitMojo {
    protected String type;
    protected boolean transaction;
    @Deprecated
    protected File src;
    protected File[] sources;
    protected String format;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)("Skip operation: " + this.type + " execution"));
            return;
        }
        super.execute();
        ArrayList<File> concatenatedSources = new ArrayList<File>();
        CollectionUtils.addIgnoreNull(concatenatedSources, (Object)this.src);
        if (this.sources != null) {
            concatenatedSources.addAll(Arrays.asList(this.sources));
        }
        try {
            IDatabaseConnection connection = this.createConnection();
            try {
                for (File source : concatenatedSources) {
                    Operation op = new Operation();
                    op.setFormat(this.format);
                    op.setSrc(source);
                    op.setTransaction(this.transaction);
                    op.setType(this.type);
                    op.execute(connection);
                }
            }
            finally {
                connection.close();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing database operation: " + this.type, e);
        }
    }
}

