/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.duradmin.spaces.controller;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManager;
import org.duracloud.common.model.AclType;
import org.duracloud.duradmin.domain.Acl;
import org.duracloud.duradmin.domain.Space;
import org.duracloud.duradmin.util.SpaceUtil;
import org.duracloud.error.ContentStoreException;
import org.duracloud.security.DuracloudUserDetailsService;
import org.duracloud.security.domain.SecurityUserBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SpaceAclController {
    protected final Logger log = LoggerFactory.getLogger(SpaceAclController.class);
    private ContentStoreManager contentStoreManager;
    private DuracloudUserDetailsService userDetailsService;

    @Autowired(required=true)
    public SpaceAclController(@Qualifier(value="contentStoreManager") ContentStoreManager contentStoreManager, DuracloudUserDetailsService userDetailsService) {
        this.contentStoreManager = contentStoreManager;
        this.userDetailsService = userDetailsService;
    }

    @RequestMapping(value={"/spaces/acls"}, method={RequestMethod.POST})
    public ModelAndView postSpaceAcls(HttpServletRequest request, @RequestParam String spaceId, @RequestParam String storeId, @RequestParam String action) throws Exception {
        Map acls = this.buildAclMap(request);
        if ("add".equals(action)) {
            Map currentAcls = this.getSpaceACLs(storeId, spaceId);
            currentAcls.putAll(acls);
            acls = currentAcls;
        }
        this.setSpaceACLs(storeId, spaceId, acls);
        acls = this.getSpaceACLs(storeId, spaceId);
        List list = SpaceUtil.toAclList((Map)acls);
        return this.createModel(list);
    }

    private ContentStore getContentStore(String storeId) throws ContentStoreException {
        return this.contentStoreManager.getContentStore(storeId);
    }

    @RequestMapping(value={"/spaces/acls"}, method={RequestMethod.GET})
    public ModelAndView getSpaceAcls(@RequestParam String spaceId, @RequestParam String storeId) throws Exception {
        Map acls = this.getSpaceACLs(storeId, spaceId);
        return this.createModel(SpaceUtil.toAclList((Map)acls));
    }

    private Map<String, AclType> getSpaceACLs(String storeId, String spaceId) throws Exception {
        return this.getContentStore(storeId).getSpaceACLs(spaceId);
    }

    private void setSpaceACLs(String storeId, String spaceId, Map<String, AclType> spaceACLs) throws Exception {
        this.getContentStore(storeId).setSpaceACLs(spaceId, spaceACLs);
    }

    private Map<String, AclType> buildAclMap(HttpServletRequest request) {
        String[] write;
        HashMap<String, AclType> acls = new HashMap<String, AclType>();
        String[] read = request.getParameterValues("read");
        if (read != null) {
            for (String name : read) {
                acls.put(name, AclType.READ);
            }
        }
        if ((write = request.getParameterValues("write")) != null) {
            for (String name : write) {
                acls.put(name, AclType.WRITE);
            }
        }
        return acls;
    }

    @RequestMapping(value={"/spaces/acls/unassignedAcls"}, method={RequestMethod.GET})
    public ModelAndView getNewUserAcls(@RequestParam String spaceId, @RequestParam String storeId) throws Exception {
        Map currentAcls = this.getSpaceACLs(storeId, spaceId);
        LinkedList<Acl> list = new LinkedList<Acl>();
        List users = this.getUsers();
        List groups = this.getGroups((Collection)users);
        groups.add("group-public");
        for (String group : groups) {
            if (currentAcls.containsKey(group)) continue;
            list.add(new Acl(group, SpaceUtil.formatAclDisplayName((String)group), false, false));
        }
        for (SecurityUserBean user : users) {
            String username = user.getUsername();
            if (currentAcls.containsKey(username) || this.isRootOrAdmin(user)) continue;
            list.add(new Acl(username, username, false, false));
        }
        SpaceUtil.sortAcls(list);
        return this.createModel(list);
    }

    private boolean isRootOrAdmin(SecurityUserBean user) {
        List auths = user.getGrantedAuthorities();
        return auths.contains("ROLE_ADMIN") || auths.contains("ROLE_ROOT");
    }

    private List<SecurityUserBean> getUsers() {
        return this.userDetailsService.getUsers();
    }

    private List<String> getGroups(Collection<SecurityUserBean> users) {
        HashSet<String> groups = new HashSet<String>();
        for (SecurityUserBean user : users) {
            for (String group : user.getGroups()) {
                groups.add(group);
            }
        }
        LinkedList<String> list = new LinkedList<String>(groups);
        Collections.sort(list);
        return list;
    }

    private ModelAndView createModel(List<Acl> acls) {
        ModelAndView mav = new ModelAndView("jsonView");
        if (acls != null) {
            mav.addObject("acls", acls);
        }
        return mav;
    }

    protected ContentStore getContentStore(Space space) throws ContentStoreException {
        return this.contentStoreManager.getContentStore(space.getStoreId());
    }
}

