/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncui.duracloudconfig;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.duracloud.syncui.domain.DuracloudConfiguration;
import org.duracloud.syncui.domain.DuracloudCredentialsForm;
import org.duracloud.syncui.domain.SpaceForm;
import org.duracloud.syncui.service.SyncConfigurationManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.mvc.servlet.AbstractFlowHandler;

@Component(value="duracloud-config")
public class DuracloudConfigFlowHandler
extends AbstractFlowHandler {
    public static final String FLOW_ID = "duracloud-config";
    private SyncConfigurationManager syncConfigurationManager;

    @Autowired
    public DuracloudConfigFlowHandler(SyncConfigurationManager synConfigurationManager) {
        this.syncConfigurationManager = synConfigurationManager;
    }

    public String getFlowId() {
        return FLOW_ID;
    }

    public String handleExecutionOutcome(FlowExecutionOutcome outcome, HttpServletRequest request, HttpServletResponse response) {
        String path = "/";
        if ("restart".equals(outcome.getOutput().get("action"))) {
            path = path + "status";
        }
        return "contextRelative:" + path;
    }

    public MutableAttributeMap createExecutionInputMap(HttpServletRequest request) {
        MutableAttributeMap map = super.createExecutionInputMap(request);
        if (map == null) {
            map = new LocalAttributeMap();
        }
        DuracloudConfiguration config = this.syncConfigurationManager.retrieveDuracloudConfiguration();
        DuracloudCredentialsForm cf = new DuracloudCredentialsForm(config);
        map.put("duracloudCredentialsForm", (Object)cf);
        SpaceForm sf = new SpaceForm();
        sf.setSpaceId(config.getSpaceId());
        map.put("spaceForm", (Object)sf);
        return map;
    }
}

