/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.client.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import org.duracloud.client.ContentStore;
import org.duracloud.client.util.ContentStoreUtil;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuracloudFileWriter
extends Writer {
    private static Logger log = LoggerFactory.getLogger(DuracloudFileWriter.class);
    private String contentId;
    private String spaceId;
    private String storeId;
    private String mimetype;
    private ContentStoreUtil contentStoreUtil;
    private File tempFile;
    private Writer writer;

    public DuracloudFileWriter(String spaceId, String contentId, String mimetype, ContentStore contentStore) throws DuraCloudRuntimeException {
        this.throwIllegalArgumentExceptionIfNull(spaceId, "spaceId");
        this.throwIllegalArgumentExceptionIfNull(spaceId, "contentId");
        this.throwIllegalArgumentExceptionIfNull(mimetype, "mimetype");
        this.throwIllegalArgumentExceptionIfNull(contentStore, "contentStore");
        try {
            this.contentId = contentId;
            this.spaceId = spaceId;
            this.mimetype = mimetype;
            this.tempFile = File.createTempFile("dc-content-item-writer", null);
            this.contentStoreUtil = new ContentStoreUtil(contentStore);
            this.storeId = contentStore.getStoreId();
            this.writer = new FileWriter(this.tempFile);
        }
        catch (IOException e) {
            log.error("constructor failed", e);
            throw new DuraCloudRuntimeException(e);
        }
    }

    private void throwIllegalArgumentExceptionIfNull(Object value, String varName) {
        if (value == null) {
            throw new IllegalArgumentException(MessageFormat.format("{0} must not be null", varName));
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkWriter();
        this.writer.flush();
        try {
            this.contentStoreUtil.storeContentStream(this.tempFile, this.spaceId, this.contentId, this.mimetype);
        }
        catch (DuraCloudRuntimeException ex) {
            throw new IOException("flush failed: " + ex.getMessage(), ex);
        }
    }

    private void checkWriter() throws IOException {
        if (this.writer == null) {
            throw new IOException("write has been closed");
        }
    }

    @Override
    public void close() throws IOException {
        this.checkWriter();
        this.writer.close();
        try {
            this.contentStoreUtil.storeContentStream(this.tempFile, this.spaceId, this.contentId, this.mimetype);
        }
        catch (DuraCloudRuntimeException ex) {
            String msg = MessageFormat.format("failed to save file ( contentId={}, spaceId={}, storeId={}, mimetype={} )", this.contentId, this.spaceId, this.storeId, this.mimetype);
            log.error(msg, ex);
            throw new IOException(msg, ex);
        }
        finally {
            this.tempFile.delete();
            this.tempFile = null;
            this.writer = null;
        }
    }

    public void writeLine(String line) throws IOException {
        this.write(line + "\n");
    }

    @Override
    public void write(String line) throws IOException {
        if (this.writer == null) {
            throw new IOException("The writer has already been closed.");
        }
        this.writer.write(line);
    }

    protected void finalize() throws Throwable {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        super.finalize();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }
}

