/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.web;

import org.duracloud.common.error.DuraCloudCheckedException;
import org.duracloud.common.web.RestHttpHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtil {
    protected static final Logger log = LoggerFactory.getLogger(NetworkUtil.class);

    public void waitForStartup(String url) throws DuraCloudCheckedException {
        this.isRunning(url, true);
    }

    public void waitForShutdown(String url) throws DuraCloudCheckedException {
        this.isRunning(url, false);
    }

    private void isRunning(String url, boolean state) throws DuraCloudCheckedException {
        int tries = 0;
        int maxTries = 40;
        boolean running = this.isRunning(url);
        while (running != state && tries++ < maxTries) {
            this.sleep(1000L);
            running = this.isRunning(url);
        }
        if (running != state) {
            this.sleep(5000L);
            running = this.isRunning(url);
        }
        if (running != state) {
            String err = state ? "Not running" : "Still running";
            throw new DuraCloudCheckedException(err + ": " + url);
        }
    }

    private boolean isRunning(String url) {
        boolean running = false;
        RestHttpHelper httpHelper = new RestHttpHelper();
        RestHttpHelper.HttpResponse response = null;
        try {
            response = httpHelper.get(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (response != null) {
            int status = response.getStatusCode();
            if (status == 200 || status == 302) {
                running = true;
            } else {
                log.debug("status code: {}", status);
            }
        }
        return running;
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

