/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncoptimize;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.duracloud.common.util.ApplicationConfig;
import org.duracloud.syncoptimize.config.SyncOptimizeConfig;
import org.duracloud.syncoptimize.config.SyncOptimizeConfigParser;
import org.duracloud.syncoptimize.data.TestDataHandler;
import org.duracloud.syncoptimize.status.SyncTestStatus;
import org.duracloud.syncoptimize.test.SyncTestManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncOptimizeDriver {
    private static final String SYNCOPT_PROPERTIES = "syncopt.properties";
    private static final String DATA_DIR_NAME = "duracloud-sync-optimize-data";
    private static final String WORK_DIR_NAME = "duracloud-sync-optimize-work";
    private final Logger log = LoggerFactory.getLogger(SyncOptimizeDriver.class);
    private String version;
    private File dataDir;
    private File workDir;
    private SyncTestStatus syncTestStatus;

    public SyncOptimizeDriver(boolean printStatus) {
        Properties props = ApplicationConfig.getPropsFromResource(SYNCOPT_PROPERTIES);
        this.version = props.getProperty("version");
        this.syncTestStatus = new SyncTestStatus(printStatus);
    }

    public int getOptimalThreads(SyncOptimizeConfig syncOptConfig) throws IOException {
        File tempDir = FileUtils.getTempDirectory();
        this.dataDir = new File(tempDir, DATA_DIR_NAME);
        this.workDir = new File(tempDir, WORK_DIR_NAME);
        String prefix = "sync-optimize/" + InetAddress.getLocalHost().getHostName() + "/";
        TestDataHandler dataHandler = new TestDataHandler();
        dataHandler.createDirectories(this.dataDir, this.workDir);
        dataHandler.createTestData(this.dataDir, syncOptConfig.getNumFiles(), syncOptConfig.getSizeFiles());
        SyncTestManager testManager = new SyncTestManager(syncOptConfig, this.dataDir, this.workDir, this.syncTestStatus, prefix);
        int optimalThreads = testManager.runTest();
        dataHandler.removeDirectories(this.dataDir, this.workDir);
        return optimalThreads;
    }

    public SyncTestStatus getSyncTestStatus() {
        return this.syncTestStatus;
    }

    private SyncOptimizeConfig processCommandLineArgs(String[] args) {
        SyncOptimizeConfigParser configParser = new SyncOptimizeConfigParser();
        SyncOptimizeConfig syncOptConfig = configParser.processCommandLine(args);
        syncOptConfig.setVersion(this.version);
        this.log.info("### Running Sync Thread Optimizer with configuration: " + syncOptConfig.getPrintableConfig());
        return syncOptConfig;
    }

    public static void main(String[] args) throws Exception {
        SyncOptimizeDriver syncOptDriver = new SyncOptimizeDriver(true);
        SyncOptimizeConfig syncOptConfig = syncOptDriver.processCommandLineArgs(args);
        System.out.println("### Running Sync Thread Optimizer with configuration: " + syncOptConfig.getPrintableConfig());
        int optimalThreads = syncOptDriver.getOptimalThreads(syncOptConfig);
        System.out.println("### Sync Thread Optimizer complete. Optimal thread count for running the DuraCloud SyncTool on this machine is: " + optimalThreads);
    }
}

