/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncui.service;

import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManager;
import org.duracloud.client.ContentStoreManagerImpl;
import org.duracloud.common.model.Credential;
import org.duracloud.error.ContentStoreException;
import org.duracloud.syncui.domain.DuracloudCredentialsForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="contentStoreFactory")
public class ContentStoreFactory {
    private static Logger log = LoggerFactory.getLogger(ContentStoreFactory.class);

    public ContentStore create(DuracloudCredentialsForm dcf) throws ContentStoreException {
        return this.create(dcf, true);
    }

    public ContentStore create(DuracloudCredentialsForm dcf, boolean retry) throws ContentStoreException {
        String username = dcf.getUsername();
        String host = dcf.getHost();
        String port = dcf.getPort();
        ContentStoreManager csm = this.createContentStoreManager(host, port);
        Credential credential = new Credential(username, dcf.getPassword());
        csm.login(credential);
        log.debug("logged into {}:{} as {}", new Object[]{host, port, username});
        ContentStore primary = retry ? csm.getPrimaryContentStore() : csm.getPrimaryContentStore(0);
        log.debug("retrieved primary content store");
        return primary;
    }

    protected ContentStoreManager createContentStoreManager(String host, String port) {
        ContentStoreManagerImpl csm = new ContentStoreManagerImpl(host, port);
        return csm;
    }
}

