/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.account.db.model;

import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.duracloud.account.db.model.BaseEntity;
import org.duracloud.account.db.model.StorageProviderAccount;

@Entity
public class AccountInfo
extends BaseEntity
implements Comparable<AccountInfo> {
    private String subdomain;
    private String acctName;
    private String orgName;
    private String department;
    @Enumerated(value=EnumType.STRING)
    private AccountStatus status;
    @OneToOne(fetch=FetchType.LAZY, optional=false, cascade={CascadeType.ALL})
    @JoinColumn(name="primary_storage_provider_account_id", nullable=false, columnDefinition="bigint(20)")
    private StorageProviderAccount primaryStorageProviderAccount;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="account_info_id", nullable=true, columnDefinition="bigint(20)")
    private Set<StorageProviderAccount> secondaryStorageProviderAccounts;

    public String getSubdomain() {
        return this.subdomain;
    }

    public void setSubdomain(String subdomain) {
        this.subdomain = subdomain;
    }

    public String getAcctName() {
        return this.acctName;
    }

    public void setAcctName(String acctName) {
        this.acctName = acctName;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public AccountStatus getStatus() {
        return this.status;
    }

    public void setStatus(AccountStatus status) {
        this.status = status;
    }

    public StorageProviderAccount getPrimaryStorageProviderAccount() {
        return this.primaryStorageProviderAccount;
    }

    public void setPrimaryStorageProviderAccount(StorageProviderAccount primaryStorageProviderAccount) {
        this.primaryStorageProviderAccount = primaryStorageProviderAccount;
    }

    public Set<StorageProviderAccount> getSecondaryStorageProviderAccounts() {
        return this.secondaryStorageProviderAccounts;
    }

    public void setSecondaryStorageProviderAccounts(Set<StorageProviderAccount> secondaryStorageProviderAccounts) {
        this.secondaryStorageProviderAccounts = secondaryStorageProviderAccounts;
    }

    @Override
    public int compareTo(AccountInfo o) {
        return this.acctName.compareTo(o.acctName);
    }

    public static enum AccountStatus {
        PENDING,
        ACTIVE,
        INACTIVE;

    }
}

