/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.mgmt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileExclusionManager {
    private static Logger log = LoggerFactory.getLogger(FileExclusionManager.class);
    private WildcardFileFilter fileFilter;

    public FileExclusionManager(File excludeFile) {
        if (excludeFile == null) {
            throw new IllegalArgumentException("excludedFile must be non-null");
        }
        List<String> excludeList = this.readExcludeFile(excludeFile);
        this.setExcludeList(excludeList);
    }

    public FileExclusionManager() {
        this.setExcludeList(new LinkedList<String>());
    }

    public FileExclusionManager(List<String> excludeList) {
        this.setExcludeList(excludeList);
    }

    private void setExcludeList(List<String> excludeList) {
        this.fileFilter = new WildcardFileFilter(excludeList, IOCase.INSENSITIVE);
    }

    private List<String> readExcludeFile(File excludeFile) {
        ArrayList<String> excludeList = new ArrayList<String>();
        try (BufferedReader excludeReader = new BufferedReader(new FileReader(excludeFile));){
            String excludeItem = excludeReader.readLine();
            while (excludeItem != null) {
                String excludedItemTrimmed = excludeItem.trim();
                excludeList.add(excludedItemTrimmed);
                log.info("Added rule from exclude list: {}", (Object)excludedItemTrimmed);
                excludeItem = excludeReader.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read exclude file " + excludeFile.getAbsolutePath() + " due to: " + e.getMessage());
        }
        return excludeList;
    }

    public boolean isExcluded(File file) {
        if (null != this.fileFilter) {
            do {
                if (!this.fileFilter.accept(file)) continue;
                log.info("{} matched one or more exclude rules: excluding...", (Object)file.getAbsolutePath());
                return true;
            } while ((file = file.getParentFile()) != null);
        }
        return false;
    }
}

