/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.primitive;

import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.impl.factory.primitive.ShortLists;
import org.eclipse.collections.impl.lazy.primitive.CollectShortToObjectIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.SelectShortIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LazyShortIterate {
    private static final LazyShortIterable EMPTY_ITERABLE = ShortLists.immutable.of().asLazy();

    private LazyShortIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static LazyShortIterable adapt(ShortIterable iterable) {
        return new LazyShortIterableAdapter(iterable);
    }

    public static LazyShortIterable select(ShortIterable iterable, ShortPredicate predicate) {
        return new SelectShortIterable(iterable, predicate);
    }

    public static <V> LazyIterable<V> collect(ShortIterable iterable, ShortToObjectFunction<? extends V> function) {
        return new CollectShortToObjectIterable<V>(iterable, function);
    }

    public static <V> LazyIterable<V> collectIf(ShortIterable iterable, ShortPredicate predicate, ShortToObjectFunction<? extends V> function) {
        return LazyShortIterate.select(iterable, predicate).collect(function);
    }

    public static LazyShortIterable empty() {
        return EMPTY_ITERABLE;
    }
}

