/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.FloatBag;
import org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.FloatIntPair;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableFloatSingletonBag;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.FloatBags;
import org.eclipse.collections.impl.iterator.ImmutableEmptyFloatIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;

@Immutable
final class ImmutableFloatEmptyBag
implements ImmutableFloatBag,
Serializable {
    static final ImmutableFloatBag INSTANCE = new ImmutableFloatEmptyBag();
    private static final long serialVersionUID = 1L;

    ImmutableFloatEmptyBag() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public ImmutableFloatBag newWith(float element) {
        return new ImmutableFloatSingletonBag(element);
    }

    public ImmutableFloatBag newWithout(float element) {
        return this;
    }

    public ImmutableFloatBag newWithAll(FloatIterable elements) {
        return FloatBags.immutable.withAll(elements);
    }

    public ImmutableFloatBag newWithoutAll(FloatIterable elements) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public boolean contains(float value) {
        return false;
    }

    public boolean containsAll(FloatIterable source) {
        return source.isEmpty();
    }

    public boolean containsAll(float ... elements) {
        return elements.length == 0;
    }

    public void forEach(FloatProcedure procedure) {
    }

    public void each(FloatProcedure procedure) {
    }

    public ImmutableFloatBag select(FloatPredicate predicate) {
        return this;
    }

    public ImmutableFloatBag reject(FloatPredicate predicate) {
        return this;
    }

    public <V> ImmutableBag<V> collect(FloatToObjectFunction<? extends V> function) {
        return Bags.immutable.of();
    }

    public MutableFloatList toList() {
        return new FloatArrayList();
    }

    public int sizeDistinct() {
        return 0;
    }

    public int occurrencesOf(float item) {
        return 0;
    }

    public void forEachWithOccurrences(FloatIntProcedure floatIntProcedure) {
    }

    public ImmutableFloatBag selectByOccurrences(IntPredicate predicate) {
        return this;
    }

    public ImmutableList<FloatIntPair> topOccurrences(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Cannot use a value of count < 0");
        }
        return Lists.immutable.empty();
    }

    public ImmutableList<FloatIntPair> bottomOccurrences(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Cannot use a value of count < 0");
        }
        return Lists.immutable.empty();
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return ifNone;
    }

    public int count(FloatPredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return false;
    }

    public double sum() {
        return 0.0;
    }

    public float min() {
        throw new NoSuchElementException();
    }

    public float max() {
        throw new NoSuchElementException();
    }

    public float maxIfEmpty(float defaultValue) {
        return defaultValue;
    }

    public float minIfEmpty(float defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public float[] toSortedArray() {
        return new float[0];
    }

    public MutableFloatList toSortedList() {
        return new FloatArrayList();
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return true;
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FloatBag)) {
            return false;
        }
        FloatBag bag = (FloatBag)obj;
        return bag.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public MutableFloatSet toSet() {
        return new FloatHashSet();
    }

    public MutableFloatBag toBag() {
        return new FloatHashBag();
    }

    public ImmutableFloatBag toImmutable() {
        return this;
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter((FloatIterable)this);
    }

    public float[] toArray() {
        return new float[0];
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FloatIterator floatIterator() {
        return ImmutableEmptyFloatIterator.INSTANCE;
    }
}

