/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongBooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongBooleanProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.map.primitive.ImmutableLongBooleanMap;
import org.eclipse.collections.api.map.primitive.LongBooleanMap;
import org.eclipse.collections.api.map.primitive.MutableLongBooleanMap;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.LongBooleanPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedLongBooleanProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableBooleanIterator;
import org.eclipse.collections.impl.map.mutable.primitive.LongBooleanHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableLongSet;

final class ImmutableLongBooleanHashMap
implements ImmutableLongBooleanMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableLongBooleanMap delegate;

    ImmutableLongBooleanHashMap(LongBooleanMap delegate) {
        this.delegate = new LongBooleanHashMap(delegate);
    }

    public boolean get(long key) {
        return this.delegate.get(key);
    }

    public boolean getIfAbsent(long key, boolean ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean getOrThrow(long key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(long key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(boolean value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(BooleanProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(LongProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(LongBooleanProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyLongIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<LongBooleanPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableLongBooleanMap select(LongBooleanPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableLongBooleanMap reject(LongBooleanPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public ImmutableLongBooleanMap toImmutable() {
        return this;
    }

    public BooleanIterator booleanIterator() {
        return new UnmodifiableBooleanIterator((BooleanIterator)this.delegate.booleanIterator());
    }

    public void forEach(BooleanProcedure procedure) {
        this.each(procedure);
    }

    public void each(BooleanProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(BooleanPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableBooleanBag select(BooleanPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableBooleanBag reject(BooleanPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(BooleanToObjectFunction<? extends V> function) {
        MutableBag bag = this.delegate.collect(function);
        return bag.toImmutable();
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public boolean[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(boolean value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(boolean ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(BooleanIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableBooleanList toList() {
        return this.delegate.toList();
    }

    public MutableBooleanSet toSet() {
        return this.delegate.toSet();
    }

    public MutableBooleanBag toBag() {
        return this.delegate.toBag();
    }

    public LazyBooleanIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableLongBooleanMap newWithKeyValue(long key, boolean value) {
        LongBooleanHashMap map = new LongBooleanHashMap(this.size() + 1);
        map.putAll((LongBooleanMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableLongBooleanMap newWithoutKey(long key) {
        LongBooleanHashMap map = new LongBooleanHashMap(this.size());
        map.putAll((LongBooleanMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableLongBooleanMap newWithoutAllKeys(LongIterable keys) {
        LongBooleanHashMap map = new LongBooleanHashMap(this.size());
        map.putAll((LongBooleanMap)this);
        LongIterator iterator = keys.longIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableLongSet keySet() {
        return UnmodifiableLongSet.of(this.delegate.keySet());
    }

    public MutableBooleanCollection values() {
        return UnmodifiableBooleanCollection.of(this.delegate.values());
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableLongBooleanMapSerializationProxy((LongBooleanMap)this);
    }

    protected static class ImmutableLongBooleanMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private LongBooleanMap map;

        public ImmutableLongBooleanMapSerializationProxy() {
        }

        protected ImmutableLongBooleanMapSerializationProxy(LongBooleanMap map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((LongBooleanProcedure)new CheckedLongBooleanProcedure(){

                    @Override
                    public void safeValue(long key, boolean value) throws IOException {
                        out.writeLong(key);
                        out.writeBoolean(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            LongBooleanHashMap deserializedMap = new LongBooleanHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readLong(), in.readBoolean());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

