/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.multimap.bag.sorted.mutable;

import java.io.Serializable;
import java.util.Comparator;
import net.jcip.annotations.GuardedBy;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.api.multimap.sortedbag.ImmutableSortedBagMultimap;
import org.eclipse.collections.api.multimap.sortedbag.MutableSortedBagMultimap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.multimap.AbstractSynchronizedMultimap;

public class SynchronizedSortedBagMultimap<K, V>
extends AbstractSynchronizedMultimap<K, V>
implements MutableSortedBagMultimap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;

    public SynchronizedSortedBagMultimap(MutableSortedBagMultimap<K, V> multimap) {
        super(multimap);
    }

    public SynchronizedSortedBagMultimap(MutableSortedBagMultimap<K, V> multimap, Object newLock) {
        super(multimap, newLock);
    }

    public static <K, V> SynchronizedSortedBagMultimap<K, V> of(MutableSortedBagMultimap<K, V> multimap) {
        if (multimap == null) {
            throw new IllegalArgumentException("cannot create a SynchronizedSortedBagMultimap for null");
        }
        return new SynchronizedSortedBagMultimap<K, V>(multimap);
    }

    public static <K, V> SynchronizedSortedBagMultimap<K, V> of(MutableSortedBagMultimap<K, V> multimap, Object lock) {
        if (multimap == null) {
            throw new IllegalArgumentException("cannot create a SynchronizedSortedBagMultimap for null");
        }
        return new SynchronizedSortedBagMultimap<K, V>(multimap, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedBag<V> replaceValues(K key, Iterable<? extends V> values) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().replaceValues(key, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedBag<V> removeAll(Object key) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().removeAll(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedBagMultimap<K, V> newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().newEmpty().asSynchronized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedBag<V> get(K key) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Comparator<? super V> comparator() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().comparator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedBagMultimap<K, V> toMutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toMutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSortedBagMultimap<K, V> toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toImmutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBagMultimap<V, K> flip() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().flip();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedBagMultimap<K, V> selectKeysValues(Predicate2<? super K, ? super V> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectKeysValues(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedBagMultimap<K, V> rejectKeysValues(Predicate2<? super K, ? super V> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().rejectKeysValues(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedBagMultimap<K, V> selectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectKeysMultiValues(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedBagMultimap<K, V> rejectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().rejectKeysMultiValues(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K2, V2> MutableBagMultimap<K2, V2> collectKeysValues(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectKeysValues(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V2> MutableListMultimap<K, V2> collectValues(Function<? super V, ? extends V2> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectValues(function);
        }
    }

    public MutableSortedBagMultimap<K, V> asSynchronized() {
        return this;
    }

    @Override
    @GuardedBy(value="getLock()")
    protected MutableSortedBagMultimap<K, V> getDelegate() {
        return (MutableSortedBagMultimap)super.getDelegate();
    }
}

