/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.jetty.ee10.servlet.DefaultServlet;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Components;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.server.TunnelSupport;
import org.eclipse.jetty.util.URIUtil;

class ServletCoreRequest
implements Request {
    private final HttpServletRequest _servletRequest;
    private final ServletContextRequest _servletContextRequest;
    private final HttpFields _httpFields;
    private final HttpURI _uri;

    ServletCoreRequest(HttpServletRequest request) {
        this._servletRequest = request;
        this._servletContextRequest = ServletContextRequest.getServletContextRequest((ServletRequest)this._servletRequest);
        HttpFields.Mutable fields = HttpFields.build();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                fields.add(new HttpField(headerName, headerValue));
            }
        }
        this._httpFields = fields.asImmutable();
        String includedServletPath = (String)request.getAttribute("jakarta.servlet.include.servlet_path");
        boolean included = includedServletPath != null;
        HttpURI.Mutable builder = HttpURI.build();
        builder.scheme(request.getScheme()).authority(request.getServerName(), request.getServerPort());
        if (included) {
            builder.path(URIUtil.addEncodedPaths((String)request.getContextPath(), (String)URIUtil.encodePath((String)DefaultServlet.getIncludedPathInContext(request, includedServletPath, false))));
        } else if (request.getDispatcherType() != DispatcherType.REQUEST) {
            builder.path(URIUtil.addEncodedPaths((String)request.getContextPath(), (String)URIUtil.encodePath((String)URIUtil.addPaths((String)this._servletRequest.getServletPath(), (String)this._servletRequest.getPathInfo()))));
        } else {
            builder.path(request.getRequestURI());
        }
        builder.query(request.getQueryString());
        this._uri = builder.asImmutable();
    }

    public HttpFields getHeaders() {
        return this._httpFields;
    }

    public HttpURI getHttpURI() {
        return this._uri;
    }

    public String getId() {
        return this._servletRequest.getRequestId();
    }

    public String getMethod() {
        return this._servletRequest.getMethod();
    }

    public HttpServletRequest getServletRequest() {
        return this._servletRequest;
    }

    public boolean isSecure() {
        return this._servletRequest.isSecure();
    }

    public Object removeAttribute(String name) {
        Object value = this._servletRequest.getAttribute(name);
        this._servletRequest.removeAttribute(name);
        return value;
    }

    public Object setAttribute(String name, Object attribute) {
        Object value = this._servletRequest.getAttribute(name);
        this._servletRequest.setAttribute(name, attribute);
        return value;
    }

    public Object getAttribute(String name) {
        return this._servletRequest.getAttribute(name);
    }

    public Set<String> getAttributeNameSet() {
        HashSet<String> set = new HashSet<String>();
        Enumeration e = this._servletRequest.getAttributeNames();
        while (e.hasMoreElements()) {
            set.add((String)e.nextElement());
        }
        return set;
    }

    public void clearAttributes() {
        Enumeration e = this._servletRequest.getAttributeNames();
        while (e.hasMoreElements()) {
            this._servletRequest.removeAttribute((String)e.nextElement());
        }
    }

    public void fail(Throwable failure) {
        throw new UnsupportedOperationException();
    }

    public Components getComponents() {
        return this._servletContextRequest.getComponents();
    }

    public ConnectionMetaData getConnectionMetaData() {
        return this._servletContextRequest.getConnectionMetaData();
    }

    public Context getContext() {
        return this._servletContextRequest.getContext();
    }

    public void demand(Runnable demandCallback) {
        throw new UnsupportedOperationException();
    }

    public HttpFields getTrailers() {
        return this._servletContextRequest.getTrailers();
    }

    public long getBeginNanoTime() {
        return this._servletContextRequest.getBeginNanoTime();
    }

    public long getHeadersNanoTime() {
        return this._servletContextRequest.getHeadersNanoTime();
    }

    public Content.Chunk read() {
        throw new UnsupportedOperationException();
    }

    public boolean consumeAvailable() {
        throw new UnsupportedOperationException();
    }

    public void addIdleTimeoutListener(Predicate<TimeoutException> onIdleTimeout) {
        this._servletContextRequest.addIdleTimeoutListener(onIdleTimeout);
    }

    public void addFailureListener(Consumer<Throwable> onFailure) {
        this._servletContextRequest.addFailureListener(onFailure);
    }

    public TunnelSupport getTunnelSupport() {
        return null;
    }

    public void addHttpStreamWrapper(Function<HttpStream, HttpStream> wrapper) {
        this._servletContextRequest.addHttpStreamWrapper(wrapper);
    }

    public Session getSession(boolean create) {
        return Session.getSession((Object)this._servletRequest.getSession(create));
    }
}

