/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher.rootfiles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.tycho.p2.impl.publisher.rootfiles.FileToPathMap;
import org.eclipse.tycho.p2.impl.publisher.rootfiles.SegmentHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootFilesProperties {
    private FileToPathMap fileSourceToDestinationMap = new FileToPathMap();
    private List<Permission> permissions = new ArrayList<Permission>();
    private StringBuilder links = new StringBuilder();

    public FileToPathMap getFileMap() {
        return this.fileSourceToDestinationMap;
    }

    public void addFiles(FileToPathMap fileSourceToDestinationMap) {
        this.fileSourceToDestinationMap.putAll(fileSourceToDestinationMap);
    }

    public Collection<Permission> getPermissions() {
        return this.permissions;
    }

    public void addPermission(String chmodPermissionPattern, String[] pathsInInstallation) {
        String[] stringArray = pathsInInstallation;
        int n = pathsInInstallation.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            this.permissions.add(new Permission(path, chmodPermissionPattern));
            ++n2;
        }
    }

    public String getLinks() {
        return this.links.toString();
    }

    public void addLinks(String[] linkValueSegments) {
        RootFilesProperties.verifySpecifiedInPairs(linkValueSegments);
        String[] stringArray = linkValueSegments;
        int n = linkValueSegments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            this.addLinkSegment(segment);
            ++n2;
        }
    }

    private static void verifySpecifiedInPairs(String[] linkValueSegments) {
        if (linkValueSegments.length % 2 != 0) {
            String message = "Links must be specified as a sequence of \"link target,link name\" pairs; the actual value \"" + SegmentHelper.segmentsToString(linkValueSegments, ',') + "\" contains an odd number of segments";
            throw new IllegalArgumentException(message);
        }
    }

    private void addLinkSegment(String segment) {
        if (this.links.length() > 0) {
            this.links.append(',');
        }
        this.links.append(segment);
    }

    public class Permission {
        private final String path;
        private final String chmodPermissionPattern;

        public Permission(String path, String chmodPermissionPattern) {
            this.path = path;
            this.chmodPermissionPattern = chmodPermissionPattern;
        }

        public String[] toP2Format() {
            return new String[]{this.chmodPermissionPattern, this.path};
        }
    }
}

