/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.repo;

import java.io.File;
import org.eclipse.tycho.core.facade.MavenContext;
import org.eclipse.tycho.locking.facade.FileLockService;
import org.eclipse.tycho.p2.impl.repo.FileBasedTychoRepositoryIndex;
import org.eclipse.tycho.p2.repository.LocalRepositoryP2Indices;
import org.eclipse.tycho.p2.repository.TychoRepositoryIndex;

public class LocalRepositoryP2IndicesImpl
implements LocalRepositoryP2Indices {
    private boolean initialized = false;
    private MavenContext mavenContext;
    private TychoRepositoryIndex artifactsIndex;
    private TychoRepositoryIndex metadataIndex;
    private FileLockService fileLockService;

    private void checkInitialized() {
        if (this.initialized) {
            return;
        }
        File localRepositoryRoot = this.mavenContext.getLocalRepositoryRoot();
        this.artifactsIndex = FileBasedTychoRepositoryIndex.createArtifactsIndex(localRepositoryRoot, this.fileLockService);
        this.metadataIndex = FileBasedTychoRepositoryIndex.createMetadataIndex(localRepositoryRoot, this.fileLockService);
        this.initialized = true;
    }

    public TychoRepositoryIndex getArtifactsIndex() {
        this.checkInitialized();
        return this.artifactsIndex;
    }

    public TychoRepositoryIndex getMetadataIndex() {
        this.checkInitialized();
        return this.metadataIndex;
    }

    public File getBasedir() {
        return this.mavenContext.getLocalRepositoryRoot();
    }

    public void setMavenContext(MavenContext mavenContext) {
        this.mavenContext = mavenContext;
    }

    public void setFileLockService(FileLockService fileLockService) {
        this.fileLockService = fileLockService;
    }
}

