/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.resolver;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.p2.repository.CacheManager;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.tycho.core.facade.MavenContext;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.p2.impl.Activator;
import org.eclipse.tycho.p2.impl.resolver.OfflineTransport;
import org.eclipse.tycho.p2.impl.resolver.P2RepositoryCache;
import org.eclipse.tycho.p2.impl.resolver.P2RepositoryCacheImpl;
import org.eclipse.tycho.p2.impl.resolver.P2ResolverImpl;
import org.eclipse.tycho.p2.impl.resolver.TychoP2RepositoryCacheManager;
import org.eclipse.tycho.p2.repository.LocalRepositoryP2Indices;
import org.eclipse.tycho.p2.resolver.facade.P2ResolverFactory;
import org.eclipse.tycho.p2.target.TargetPlatformBuilderImpl;

public class P2ResolverFactoryImpl
implements P2ResolverFactory {
    private MavenContext mavenContext;
    private LocalRepositoryP2Indices localRepoIndices;
    private static final Map<AgentKey, IProvisioningAgent> agents = new HashMap<AgentKey, IProvisioningAgent>();

    public TargetPlatformBuilderImpl createTargetPlatformBuilder(String bree, boolean disableP2Mirrors) {
        IProvisioningAgent agent = P2ResolverFactoryImpl.getProvisioningAgent(this.mavenContext.getLocalRepositoryRoot(), this.mavenContext.isOffline(), this.mavenContext.getLogger());
        return new TargetPlatformBuilderImpl(agent, this.mavenContext, bree, this.localRepoIndices, disableP2Mirrors);
    }

    public P2ResolverImpl createResolver() {
        return new P2ResolverImpl(this.mavenContext.getLogger());
    }

    public static synchronized IProvisioningAgent getProvisioningAgent(File localMavenRepositoryRoot, boolean offline, MavenLogger logger) {
        AgentKey agentKey = new AgentKey(localMavenRepositoryRoot, offline);
        IProvisioningAgent agent = agents.get(agentKey);
        if (agent == null) {
            try {
                OfflineTransport transport;
                agent = Activator.newProvisioningAgent();
                if (offline) {
                    transport = new OfflineTransport();
                    agent.registerService(Transport.SERVICE_NAME, (Object)transport);
                } else {
                    transport = (Transport)agent.getService(Transport.SERVICE_NAME);
                }
                TychoP2RepositoryCacheManager cacheMgr = new TychoP2RepositoryCacheManager(transport, logger);
                cacheMgr.setOffline(offline);
                cacheMgr.setLocalRepositoryLocation(localMavenRepositoryRoot);
                agent.registerService(CacheManager.SERVICE_NAME, (Object)cacheMgr);
                P2RepositoryCacheImpl tychoCache = new P2RepositoryCacheImpl();
                agent.registerService(P2RepositoryCache.SERVICE_NAME, (Object)tychoCache);
                agents.put(agentKey, agent);
            }
            catch (ProvisionException e) {
                throw new RuntimeException(e);
            }
        }
        return agent;
    }

    public void setMavenContext(MavenContext mavenContext) {
        this.mavenContext = mavenContext;
    }

    public void setLocalRepositoryIndices(LocalRepositoryP2Indices localRepoIndices) {
        this.localRepoIndices = localRepoIndices;
    }

    public static void purgeAgents() {
        agents.clear();
    }

    private static class AgentKey {
        public final File localMavenRepositoryRoot;
        public final boolean offline;

        public AgentKey(File localMavenRepositoryRoot, boolean offline) {
            this.localMavenRepositoryRoot = localMavenRepositoryRoot;
            this.offline = offline;
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + this.localMavenRepositoryRoot.hashCode();
            hash = hash * 31 + (this.offline ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AgentKey)) {
                return false;
            }
            AgentKey other = (AgentKey)obj;
            return this.localMavenRepositoryRoot.equals(other.localMavenRepositoryRoot) && this.offline == other.offline;
        }
    }
}

