/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.resolver;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.repository.CacheManager;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.tycho.core.facade.MavenLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TychoP2RepositoryCacheManager
extends CacheManager {
    public static final String CACHE_RELPATH = ".cache/tycho/p2-repository-metadata";
    private boolean offline;
    private File localRepositoryLocation;
    private final MavenLogger logger;

    public TychoP2RepositoryCacheManager(Transport transport, MavenLogger logger) {
        super(null, transport);
        this.logger = logger;
    }

    public File createCache(URI repositoryLocation, String prefix, IProgressMonitor monitor) throws IOException, ProvisionException {
        File cacheFile = this.getCache(repositoryLocation, prefix);
        if (this.offline) {
            if (cacheFile != null) {
                return cacheFile;
            }
            throw new ProvisionException("Repository system is offline and no local cache available for " + repositoryLocation.toString());
        }
        try {
            return super.createCache(repositoryLocation, prefix, monitor);
        }
        catch (IOException e) {
            return this.handleCreateCacheException(cacheFile, repositoryLocation, e);
        }
        catch (ProvisionException e) {
            return this.handleCreateCacheException(cacheFile, repositoryLocation, e);
        }
    }

    private <T extends Exception> File handleCreateCacheException(File cacheFile, URI repositoryLocation, T e) throws T {
        if (cacheFile != null) {
            String message = "Failed to access p2 repository " + repositoryLocation.toASCIIString() + ", use local cache.";
            if (this.logger.isDebugEnabled()) {
                this.logger.warn(message, e);
            } else {
                message = String.valueOf(message) + " " + e.getMessage();
                this.logger.warn(message);
            }
            return cacheFile;
        }
        throw e;
    }

    protected File getCacheDirectory() {
        return new File(this.localRepositoryLocation, CACHE_RELPATH);
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public void setLocalRepositoryLocation(File localRepositoryLocation) {
        this.localRepositoryLocation = localRepositoryLocation;
    }
}

