/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.actions.JREAction;
import org.eclipse.equinox.p2.query.QueryUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JREInstallableUnits {
    private final String executionEnvironment;

    public JREInstallableUnits(String executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
    }

    public boolean isJREUI(IInstallableUnit iu) {
        return iu.getId().startsWith("a.jre") || iu.getId().startsWith("config.a.jre");
    }

    public Collection<IInstallableUnit> getJREIUs() {
        LinkedHashMap<VersionedId, IInstallableUnit> units = new LinkedHashMap<VersionedId, IInstallableUnit>();
        JREInstallableUnits.put(units, JREInstallableUnits.newIU("a.jre", Version.create((String)"1.6.0")));
        JREInstallableUnits.put(units, JREInstallableUnits.newIU("a.jre.javase", Version.create((String)"1.6.0")));
        JREInstallableUnits.put(units, JREInstallableUnits.newIU("config.a.jre.javase", Version.create((String)"1.6.0")));
        PublisherResult results = new PublisherResult();
        new JREAction(this.executionEnvironment).perform((IPublisherInfo)new PublisherInfo(), (IPublisherResult)results, null);
        results.query(QueryUtil.ALL_UNITS, null);
        Iterator iterator = results.query(QueryUtil.ALL_UNITS, null).iterator();
        while (iterator.hasNext()) {
            JREInstallableUnits.put(units, (IInstallableUnit)iterator.next());
        }
        return units.values();
    }

    private static IInstallableUnit newIU(String id, Version version) {
        MetadataFactory.InstallableUnitDescription iud = new MetadataFactory.InstallableUnitDescription();
        iud.setId(id);
        iud.setVersion(version);
        iud.addProvidedCapabilities(Collections.singleton(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)id, (Version)version)));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud);
    }

    private static void put(Map<VersionedId, IInstallableUnit> units, IInstallableUnit unit) {
        units.put(new VersionedId(unit.getId(), unit.getVersion()), unit);
    }
}

