/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.alias;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.test.ESTestCase;

public final class RandomAliasActionsGenerator {
    private RandomAliasActionsGenerator() {
    }

    public static IndicesAliasesRequest.AliasActions randomAliasAction() {
        return RandomAliasActionsGenerator.randomAliasAction(false);
    }

    public static IndicesAliasesRequest.AliasActions randomAliasAction(boolean useStringAsFilter) {
        int i;
        IndicesAliasesRequest.AliasActions action = new IndicesAliasesRequest.AliasActions(ESTestCase.randomFrom(IndicesAliasesRequest.AliasActions.Type.values()));
        if (ESTestCase.randomBoolean()) {
            action.index(ESTestCase.randomAlphaOfLength(5));
        } else {
            int numIndices = ESTestCase.randomIntBetween(1, 5);
            String[] indices = new String[numIndices];
            for (i = 0; i < numIndices; ++i) {
                indices[i] = "index-" + ESTestCase.randomAlphaOfLengthBetween(2, 5).toLowerCase(Locale.ROOT);
            }
            action.indices(indices);
        }
        if (action.actionType() != IndicesAliasesRequest.AliasActions.Type.REMOVE_INDEX) {
            if (ESTestCase.randomBoolean()) {
                action.alias(ESTestCase.randomAlphaOfLength(5));
            } else {
                int numAliases = ESTestCase.randomIntBetween(1, 5);
                String[] aliases = new String[numAliases];
                for (i = 0; i < numAliases; ++i) {
                    aliases[i] = "alias-" + ESTestCase.randomAlphaOfLengthBetween(2, 5).toLowerCase(Locale.ROOT);
                }
                action.aliases(aliases);
            }
        }
        if (action.actionType() == IndicesAliasesRequest.AliasActions.Type.ADD) {
            if (ESTestCase.randomBoolean()) {
                if (useStringAsFilter) {
                    action.filter(ESTestCase.randomAlphaOfLength(5));
                } else {
                    action.filter(RandomAliasActionsGenerator.randomMap(ESTestCase.randomInt(5)));
                }
            }
            if (ESTestCase.randomBoolean()) {
                if (ESTestCase.randomBoolean()) {
                    action.routing(RandomAliasActionsGenerator.randomRouting().toString());
                } else {
                    action.searchRouting(RandomAliasActionsGenerator.randomRouting().toString());
                    action.indexRouting(RandomAliasActionsGenerator.randomRouting().toString());
                }
            }
            if (ESTestCase.randomBoolean()) {
                action.writeIndex(Boolean.valueOf(ESTestCase.randomBoolean()));
            }
        }
        return action;
    }

    public static Map<String, Object> randomMap(int maxDepth) {
        int members = ESTestCase.between(0, 5);
        HashMap<String, Object> result = new HashMap<String, Object>(members);
        for (int i = 0; i < members; ++i) {
            Map<String, Object> value;
            switch (ESTestCase.between(0, 3)) {
                case 0: {
                    if (maxDepth > 0) {
                        value = RandomAliasActionsGenerator.randomMap(maxDepth - 1);
                        break;
                    }
                    value = ESTestCase.randomAlphaOfLength(5);
                    break;
                }
                case 1: {
                    value = ESTestCase.randomAlphaOfLength(5);
                    break;
                }
                case 2: {
                    value = ESTestCase.randomBoolean();
                    break;
                }
                case 3: {
                    value = ESTestCase.randomLong();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            result.put(ESTestCase.randomAlphaOfLength(5), value);
        }
        return result;
    }

    public static Object randomRouting() {
        return ESTestCase.randomBoolean() ? ESTestCase.randomAlphaOfLength(5) : Integer.valueOf(ESTestCase.randomInt());
    }
}

