/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.bulk.MappingUpdatePerformer;
import org.elasticsearch.action.bulk.TransportShardBulkAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.resync.ResyncReplicationRequest;
import org.elasticsearch.action.resync.ResyncReplicationResponse;
import org.elasticsearch.action.resync.TransportResyncReplicationAction;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.action.support.replication.TransportWriteActionTestHelper;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingHelper;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.TestShardRouting;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.DocIdSeqNoAndTerm;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.InternalEngineFactory;
import org.elasticsearch.index.seqno.GlobalCheckpointSyncAction;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardTestCase;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.PrimaryReplicaSyncer;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.indices.recovery.RecoveryTarget;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public abstract class ESIndexLevelReplicationTestCase
extends IndexShardTestCase {
    protected final Index index = new Index("test", "uuid");
    private final ShardId shardId = new ShardId(this.index, 0);
    protected final Map<String, String> indexMapping = Collections.singletonMap("type", "{ \"type\": {} }");

    protected ReplicationGroup createGroup(int replicas) throws IOException {
        return this.createGroup(replicas, Settings.EMPTY);
    }

    protected ReplicationGroup createGroup(int replicas, Settings settings) throws IOException {
        IndexMetaData metaData = this.buildIndexMetaData(replicas, settings, this.indexMapping);
        return new ReplicationGroup(metaData);
    }

    protected IndexMetaData buildIndexMetaData(int replicas) throws IOException {
        return this.buildIndexMetaData(replicas, this.indexMapping);
    }

    protected IndexMetaData buildIndexMetaData(int replicas, Map<String, String> mappings) throws IOException {
        return this.buildIndexMetaData(replicas, Settings.EMPTY, mappings);
    }

    protected IndexMetaData buildIndexMetaData(int replicas, Settings indexSettings, Map<String, String> mappings) throws IOException {
        Settings settings = Settings.builder().put("index.version.created", Version.CURRENT).put("index.number_of_replicas", replicas).put("index.number_of_shards", 1).put(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), ESIndexLevelReplicationTestCase.randomBoolean()).put(IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING.getKey(), ESIndexLevelReplicationTestCase.randomBoolean() ? (Long)IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING.get(Settings.EMPTY) : (long)ESIndexLevelReplicationTestCase.between(0, 1000)).put(indexSettings).build();
        IndexMetaData.Builder metaData = IndexMetaData.builder((String)this.index.getName()).settings(settings).primaryTerm(0, (long)ESIndexLevelReplicationTestCase.randomIntBetween(1, 100));
        for (Map.Entry<String, String> typeMapping : mappings.entrySet()) {
            metaData.putMapping(typeMapping.getKey(), typeMapping.getValue());
        }
        return metaData.build();
    }

    protected IndexRequest copyIndexRequest(IndexRequest inRequest) throws IOException {
        IndexRequest outRequest = new IndexRequest();
        try (BytesStreamOutput out = new BytesStreamOutput();){
            inRequest.writeTo((StreamOutput)out);
            try (StreamInput in = out.bytes().streamInput();){
                outRequest.readFrom(in);
            }
        }
        return outRequest;
    }

    protected DiscoveryNode getDiscoveryNode(String id) {
        return new DiscoveryNode(id, id, ESIndexLevelReplicationTestCase.buildNewFakeTransportAddress(), Collections.emptyMap(), Collections.singleton(DiscoveryNode.Role.DATA), Version.CURRENT);
    }

    private TransportWriteAction.WritePrimaryResult<BulkShardRequest, BulkShardResponse> executeShardBulkOnPrimary(IndexShard primary, BulkShardRequest request) throws Exception {
        TransportWriteAction.WritePrimaryResult result;
        for (BulkItemRequest itemRequest : request.items()) {
            if (!(itemRequest.request() instanceof IndexRequest)) continue;
            ((IndexRequest)itemRequest.request()).process(Version.CURRENT, null, this.index.getName());
        }
        PlainActionFuture permitAcquiredFuture = new PlainActionFuture();
        primary.acquirePrimaryOperationPermit((ActionListener)permitAcquiredFuture, "same", (Object)request);
        try (Releasable ignored = (Releasable)permitAcquiredFuture.actionGet();){
            MappingUpdatePerformer noopMappingUpdater = (update, shardId, type) -> {};
            result = TransportShardBulkAction.performOnPrimary((BulkShardRequest)request, (IndexShard)primary, null, System::currentTimeMillis, (MappingUpdatePerformer)noopMappingUpdater, null);
        }
        TransportWriteActionTestHelper.performPostWriteActions(primary, request, result.location, this.logger);
        return result;
    }

    private <Request extends ReplicatedWriteRequest> BulkShardRequest executeReplicationRequestOnPrimary(IndexShard primary, Request request) throws Exception {
        BulkShardRequest bulkShardRequest = new BulkShardRequest(this.shardId, request.getRefreshPolicy(), new BulkItemRequest[]{new BulkItemRequest(0, (DocWriteRequest)request)});
        return (BulkShardRequest)this.executeShardBulkOnPrimary(primary, bulkShardRequest).replicaRequest();
    }

    private void executeShardBulkOnReplica(BulkShardRequest request, IndexShard replica, long operationPrimaryTerm, long globalCheckpointOnPrimary, long maxSeqNoOfUpdatesOrDeletes) throws Exception {
        Translog.Location location;
        PlainActionFuture permitAcquiredFuture = new PlainActionFuture();
        replica.acquireReplicaOperationPermit(operationPrimaryTerm, globalCheckpointOnPrimary, maxSeqNoOfUpdatesOrDeletes, (ActionListener)permitAcquiredFuture, "same", (Object)request);
        try (Releasable ignored = (Releasable)permitAcquiredFuture.actionGet();){
            location = TransportShardBulkAction.performOnReplica((BulkShardRequest)request, (IndexShard)replica);
        }
        TransportWriteActionTestHelper.performPostWriteActions(replica, request, location, this.logger);
    }

    BulkShardRequest indexOnPrimary(IndexRequest request, IndexShard primary) throws Exception {
        return this.executeReplicationRequestOnPrimary(primary, request);
    }

    BulkShardRequest deleteOnPrimary(DeleteRequest request, IndexShard primary) throws Exception {
        return this.executeReplicationRequestOnPrimary(primary, request);
    }

    void indexOnReplica(BulkShardRequest request, ReplicationGroup group, IndexShard replica) throws Exception {
        this.indexOnReplica(request, group, replica, group.primary.getPendingPrimaryTerm());
    }

    void indexOnReplica(BulkShardRequest request, ReplicationGroup group, IndexShard replica, long term) throws Exception {
        this.executeShardBulkOnReplica(request, replica, term, group.primary.getGlobalCheckpoint(), group.primary.getMaxSeqNoOfUpdatesOrDeletes());
    }

    void deleteOnReplica(BulkShardRequest request, ReplicationGroup group, IndexShard replica) throws Exception {
        this.executeShardBulkOnReplica(request, replica, group.primary.getPendingPrimaryTerm(), group.primary.getGlobalCheckpoint(), group.primary.getMaxSeqNoOfUpdatesOrDeletes());
    }

    private TransportWriteAction.WritePrimaryResult<ResyncReplicationRequest, ResyncReplicationResponse> executeResyncOnPrimary(IndexShard primary, ResyncReplicationRequest request) throws Exception {
        TransportWriteAction.WritePrimaryResult result = new TransportWriteAction.WritePrimaryResult((ReplicatedWriteRequest)TransportResyncReplicationAction.performOnPrimary((ResyncReplicationRequest)request, (IndexShard)primary), (ReplicationResponse)new ResyncReplicationResponse(), null, null, primary, this.logger);
        TransportWriteActionTestHelper.performPostWriteActions(primary, request, result.location, this.logger);
        return result;
    }

    private void executeResyncOnReplica(IndexShard replica, ResyncReplicationRequest request, long operationPrimaryTerm, long globalCheckpointOnPrimary, long maxSeqNoOfUpdatesOrDeletes) throws Exception {
        Translog.Location location;
        PlainActionFuture acquirePermitFuture = new PlainActionFuture();
        replica.acquireReplicaOperationPermit(operationPrimaryTerm, globalCheckpointOnPrimary, maxSeqNoOfUpdatesOrDeletes, (ActionListener)acquirePermitFuture, "same", (Object)request);
        try (Releasable ignored = (Releasable)acquirePermitFuture.actionGet();){
            location = TransportResyncReplicationAction.performOnReplica((ResyncReplicationRequest)request, (IndexShard)replica);
        }
        TransportWriteActionTestHelper.performPostWriteActions(replica, request, location, this.logger);
    }

    static /* synthetic */ ThreadPool access$000(ESIndexLevelReplicationTestCase x0) {
        return x0.threadPool;
    }

    class ResyncAction
    extends ReplicationAction<ResyncReplicationRequest, ResyncReplicationRequest, ResyncReplicationResponse> {
        ResyncAction(ResyncReplicationRequest request, ActionListener<ResyncReplicationResponse> listener, ReplicationGroup group) {
            super(ESIndexLevelReplicationTestCase.this, (ReplicationRequest)request, listener, group, "resync");
        }

        @Override
        protected ReplicationAction.PrimaryResult performOnPrimary(IndexShard primary, ResyncReplicationRequest request) throws Exception {
            TransportWriteAction.WritePrimaryResult result = ESIndexLevelReplicationTestCase.this.executeResyncOnPrimary(primary, request);
            return new ReplicationAction.PrimaryResult((ReplicationAction)this, (ReplicationRequest)((ResyncReplicationRequest)result.replicaRequest()), (ReplicationResponse)((ResyncReplicationResponse)result.finalResponseIfSuccessful));
        }

        @Override
        protected void performOnReplica(ResyncReplicationRequest request, IndexShard replica) throws Exception {
            ESIndexLevelReplicationTestCase.this.executeResyncOnReplica(replica, request, this.getPrimaryShard().getPendingPrimaryTerm(), this.getPrimaryShard().getGlobalCheckpoint(), this.getPrimaryShard().getMaxSeqNoOfUpdatesOrDeletes());
        }
    }

    class GlobalCheckpointSync
    extends ReplicationAction<GlobalCheckpointSyncAction.Request, GlobalCheckpointSyncAction.Request, ReplicationResponse> {
        GlobalCheckpointSync(ActionListener<ReplicationResponse> listener, ReplicationGroup replicationGroup) {
            super(ESIndexLevelReplicationTestCase.this, (ReplicationRequest)new GlobalCheckpointSyncAction.Request(replicationGroup.getPrimary().shardId()), listener, replicationGroup, "global_checkpoint_sync");
        }

        @Override
        protected ReplicationAction.PrimaryResult performOnPrimary(IndexShard primary, GlobalCheckpointSyncAction.Request request) throws Exception {
            primary.sync();
            return new ReplicationAction.PrimaryResult((ReplicationAction)this, (ReplicationRequest)request, new ReplicationResponse());
        }

        @Override
        protected void performOnReplica(GlobalCheckpointSyncAction.Request request, IndexShard replica) throws IOException {
            replica.sync();
        }
    }

    class WriteReplicationAction
    extends ReplicationAction<BulkShardRequest, BulkShardRequest, BulkShardResponse> {
        WriteReplicationAction(BulkShardRequest request, ActionListener<BulkShardResponse> listener, ReplicationGroup replicationGroup) {
            super(ESIndexLevelReplicationTestCase.this, (ReplicationRequest)request, listener, replicationGroup, "indexing");
        }

        @Override
        protected ReplicationAction.PrimaryResult performOnPrimary(IndexShard primary, BulkShardRequest request) throws Exception {
            TransportWriteAction.WritePrimaryResult result = ESIndexLevelReplicationTestCase.this.executeShardBulkOnPrimary(primary, request);
            return new ReplicationAction.PrimaryResult((ReplicationAction)this, (ReplicationRequest)((BulkShardRequest)result.replicaRequest()), (ReplicationResponse)((BulkShardResponse)result.finalResponseIfSuccessful));
        }

        @Override
        protected void performOnReplica(BulkShardRequest request, IndexShard replica) throws Exception {
            ESIndexLevelReplicationTestCase.this.executeShardBulkOnReplica(request, replica, this.getPrimaryShard().getPendingPrimaryTerm(), this.getPrimaryShard().getGlobalCheckpoint(), this.getPrimaryShard().getMaxSeqNoOfUpdatesOrDeletes());
        }
    }

    protected static abstract class ReplicationAction<Request extends ReplicationRequest<Request>, ReplicaRequest extends ReplicationRequest<ReplicaRequest>, Response extends ReplicationResponse> {
        private final Request request;
        private ActionListener<Response> listener;
        private final ReplicationTargets replicationTargets;
        private final String opType;
        final /* synthetic */ ESIndexLevelReplicationTestCase this$0;

        protected ReplicationAction(Request request, ActionListener<Response> listener, ReplicationGroup group, String opType) {
            this.this$0 = this$0;
            this.request = request;
            this.listener = listener;
            this.replicationTargets = group.getReplicationTargets();
            this.opType = opType;
        }

        public void execute() {
            try {
                new ReplicationOperation(this.request, (ReplicationOperation.Primary)new PrimaryRef(), (ActionListener)new ActionListener<PrimaryResult>(){

                    public void onResponse(PrimaryResult result) {
                        result.respond(ReplicationAction.this.listener);
                    }

                    public void onFailure(Exception e) {
                        ReplicationAction.this.listener.onFailure(e);
                    }
                }, (ReplicationOperation.Replicas)new ReplicasRef(), this.this$0.logger, this.opType).execute();
            }
            catch (Exception e) {
                this.listener.onFailure(e);
            }
        }

        IndexShard getPrimaryShard() {
            return this.replicationTargets.primary;
        }

        protected abstract PrimaryResult performOnPrimary(IndexShard var1, Request var2) throws Exception;

        protected abstract void performOnReplica(ReplicaRequest var1, IndexShard var2) throws Exception;

        protected static class PrimaryResult
        implements ReplicationOperation.PrimaryResult<ReplicaRequest> {
            final ReplicaRequest replicaRequest;
            final Response finalResponse;
            final /* synthetic */ ReplicationAction this$1;

            public PrimaryResult(ReplicaRequest replicaRequest, Response finalResponse) {
                this.this$1 = this$1;
                this.replicaRequest = replicaRequest;
                this.finalResponse = finalResponse;
            }

            public ReplicaRequest replicaRequest() {
                return this.replicaRequest;
            }

            public void setShardInfo(ReplicationResponse.ShardInfo shardInfo) {
                this.finalResponse.setShardInfo(shardInfo);
            }

            public void respond(ActionListener<Response> listener) {
                listener.onResponse(this.finalResponse);
            }
        }

        class ReplicasRef
        implements ReplicationOperation.Replicas<ReplicaRequest> {
            ReplicasRef() {
            }

            public void performOn(ShardRouting replicaRouting, final ReplicaRequest request, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes, final ActionListener<ReplicationOperation.ReplicaResponse> listener) {
                final IndexShard replica = ReplicationAction.this.replicationTargets.findReplicaShard(replicaRouting);
                replica.acquireReplicaOperationPermit(ReplicationAction.this.getPrimaryShard().getPendingPrimaryTerm(), globalCheckpoint, maxSeqNoOfUpdatesOrDeletes, (ActionListener)new ActionListener<Releasable>(){

                    public void onResponse(Releasable releasable) {
                        try {
                            ReplicationAction.this.performOnReplica(request, replica);
                            releasable.close();
                            listener.onResponse((Object)new TransportReplicationAction.ReplicaResponse(replica.getLocalCheckpoint(), replica.getGlobalCheckpoint()));
                        }
                        catch (Exception e) {
                            Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{releasable});
                            listener.onFailure(e);
                        }
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                }, "index", request);
            }

            public void failShardIfNeeded(ShardRouting replica, String message, Exception exception, Runnable onSuccess, Consumer<Exception> onPrimaryDemoted, Consumer<Exception> onIgnoredFailure) {
                throw new UnsupportedOperationException("failing shard " + replica + " isn't supported. failure: " + message, exception);
            }

            public void markShardCopyAsStaleIfNeeded(ShardId shardId, String allocationId, Runnable onSuccess, Consumer<Exception> onPrimaryDemoted, Consumer<Exception> onIgnoredFailure) {
                throw new UnsupportedOperationException("can't mark " + shardId + ", aid [" + allocationId + "] as stale");
            }
        }

        class PrimaryRef
        implements ReplicationOperation.Primary<Request, ReplicaRequest, PrimaryResult> {
            PrimaryRef() {
            }

            public ShardRouting routingEntry() {
                return ReplicationAction.this.getPrimaryShard().routingEntry();
            }

            public void failShard(String message, Exception exception) {
                throw new UnsupportedOperationException("failing a primary isn't supported. failure: " + message, exception);
            }

            public PrimaryResult perform(Request request) throws Exception {
                return ReplicationAction.this.performOnPrimary(ReplicationAction.this.getPrimaryShard(), request);
            }

            public void updateLocalCheckpointForShard(String allocationId, long checkpoint) {
                ReplicationAction.this.getPrimaryShard().updateLocalCheckpointForShard(allocationId, checkpoint);
            }

            public void updateGlobalCheckpointForShard(String allocationId, long globalCheckpoint) {
                ReplicationAction.this.getPrimaryShard().updateGlobalCheckpointForShard(allocationId, globalCheckpoint);
            }

            public long localCheckpoint() {
                return ReplicationAction.this.getPrimaryShard().getLocalCheckpoint();
            }

            public long globalCheckpoint() {
                return ReplicationAction.this.getPrimaryShard().getGlobalCheckpoint();
            }

            public long maxSeqNoOfUpdatesOrDeletes() {
                return ReplicationAction.this.getPrimaryShard().getMaxSeqNoOfUpdatesOrDeletes();
            }

            public org.elasticsearch.index.shard.ReplicationGroup getReplicationGroup() {
                return ReplicationAction.this.getPrimaryShard().getReplicationGroup();
            }
        }
    }

    static final class ReplicationTargets {
        final IndexShard primary;
        final List<IndexShard> replicas;

        ReplicationTargets(IndexShard primary, List<IndexShard> replicas) {
            this.primary = primary;
            this.replicas = replicas;
        }

        synchronized void addReplica(IndexShard replica) {
            this.replicas.add(replica);
        }

        synchronized IndexShard findReplicaShard(ShardRouting replicaRouting) {
            for (IndexShard replica : this.replicas) {
                if (!replica.routingEntry().isSameAllocation(replicaRouting)) continue;
                return replica;
            }
            throw new AssertionError((Object)("replica [" + replicaRouting + "] is not found; replicas[" + this.replicas + "] primary[" + this.primary + "]"));
        }
    }

    protected class ReplicationGroup
    implements AutoCloseable,
    Iterable<IndexShard> {
        private IndexShard primary;
        private IndexMetaData indexMetaData;
        private final List<IndexShard> replicas;
        private final AtomicInteger replicaId = new AtomicInteger();
        private final AtomicInteger docId = new AtomicInteger();
        boolean closed = false;
        private ReplicationTargets replicationTargets;
        private final PrimaryReplicaSyncer primaryReplicaSyncer = new PrimaryReplicaSyncer(new TaskManager(Settings.EMPTY, ESIndexLevelReplicationTestCase.access$000(ESIndexLevelReplicationTestCase.this), Collections.emptySet()), (request, parentTask, primaryAllocationId, primaryTerm, listener) -> {
            try {
                new ResyncAction(request, (ActionListener<ResyncReplicationResponse>)listener, this).execute();
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        });

        protected ReplicationGroup(IndexMetaData indexMetaData) throws IOException {
            ShardRouting primaryRouting = this.createShardRouting("s0", true);
            this.primary = ESIndexLevelReplicationTestCase.this.newShard(primaryRouting, indexMetaData, null, this.getEngineFactory(primaryRouting), () -> {}, new IndexingOperationListener[0]);
            this.replicas = new CopyOnWriteArrayList<IndexShard>();
            this.indexMetaData = indexMetaData;
            this.updateAllocationIDsOnPrimary();
            for (int i = 0; i < indexMetaData.getNumberOfReplicas(); ++i) {
                this.addReplica();
            }
        }

        private ShardRouting createShardRouting(String nodeId, boolean primary) {
            return TestShardRouting.newShardRouting(ESIndexLevelReplicationTestCase.this.shardId, nodeId, primary, ShardRoutingState.INITIALIZING, (RecoverySource)(primary ? RecoverySource.EmptyStoreRecoverySource.INSTANCE : RecoverySource.PeerRecoverySource.INSTANCE));
        }

        protected EngineFactory getEngineFactory(ShardRouting routing) {
            return new InternalEngineFactory();
        }

        public int indexDocs(int numOfDoc) throws Exception {
            for (int doc = 0; doc < numOfDoc; ++doc) {
                IndexRequest indexRequest = new IndexRequest(ESIndexLevelReplicationTestCase.this.index.getName(), "type", Integer.toString(this.docId.incrementAndGet())).source("{}", XContentType.JSON);
                BulkItemResponse response = this.index(indexRequest);
                if (response.isFailed()) {
                    throw response.getFailure().getCause();
                }
                Assert.assertEquals((Object)DocWriteResponse.Result.CREATED, (Object)response.getResponse().getResult());
            }
            return numOfDoc;
        }

        public int appendDocs(int numOfDoc) throws Exception {
            for (int doc = 0; doc < numOfDoc; ++doc) {
                IndexRequest indexRequest = new IndexRequest(ESIndexLevelReplicationTestCase.this.index.getName(), "type").source("{}", XContentType.JSON);
                BulkItemResponse response = this.index(indexRequest);
                if (response.isFailed()) {
                    throw response.getFailure().getCause();
                }
                if (response.isFailed()) continue;
                Assert.assertEquals((Object)DocWriteResponse.Result.CREATED, (Object)response.getResponse().getResult());
            }
            return numOfDoc;
        }

        public BulkItemResponse index(IndexRequest indexRequest) throws Exception {
            return this.executeWriteRequest((DocWriteRequest<?>)indexRequest, indexRequest.getRefreshPolicy());
        }

        public BulkItemResponse delete(DeleteRequest deleteRequest) throws Exception {
            return this.executeWriteRequest((DocWriteRequest<?>)deleteRequest, deleteRequest.getRefreshPolicy());
        }

        private BulkItemResponse executeWriteRequest(DocWriteRequest<?> writeRequest, WriteRequest.RefreshPolicy refreshPolicy) throws Exception {
            PlainActionFuture listener = new PlainActionFuture();
            ActionListener wrapBulkListener = ActionListener.wrap(bulkShardResponse -> listener.onResponse((Object)bulkShardResponse.getResponses()[0]), arg_0 -> ((PlainActionFuture)listener).onFailure(arg_0));
            BulkItemRequest[] items = new BulkItemRequest[]{new BulkItemRequest(0, writeRequest)};
            BulkShardRequest request = new BulkShardRequest(ESIndexLevelReplicationTestCase.this.shardId, refreshPolicy, items);
            new WriteReplicationAction(request, (ActionListener<BulkShardResponse>)wrapBulkListener, this).execute();
            return (BulkItemResponse)listener.get();
        }

        public synchronized void startAll() throws IOException {
            this.startReplicas(this.replicas.size());
        }

        public synchronized int startReplicas(int numOfReplicasToStart) throws IOException {
            if (this.primary.routingEntry().initializing()) {
                this.startPrimary();
            }
            int started = 0;
            for (IndexShard replicaShard : this.replicas) {
                if (!replicaShard.routingEntry().initializing()) continue;
                this.recoverReplica(replicaShard);
                if (++started <= numOfReplicasToStart) continue;
                break;
            }
            return started;
        }

        public void startPrimary() throws IOException {
            DiscoveryNode pNode = ESIndexLevelReplicationTestCase.this.getDiscoveryNode(this.primary.routingEntry().currentNodeId());
            this.primary.markAsRecovering("store", new RecoveryState(this.primary.routingEntry(), pNode, null));
            this.primary.recoverFromStore();
            HashSet<String> activeIds = new HashSet<String>();
            activeIds.addAll(this.activeIds());
            activeIds.add(this.primary.routingEntry().allocationId().getId());
            ShardRouting startedRoutingEntry = ShardRoutingHelper.moveToStarted(this.primary.routingEntry());
            IndexShardRoutingTable routingTable = this.routingTable(shr -> shr == this.primary.routingEntry() ? startedRoutingEntry : shr);
            this.primary.updateShardState(startedRoutingEntry, this.primary.getPendingPrimaryTerm(), null, currentClusterStateVersion.incrementAndGet(), activeIds, routingTable, Collections.emptySet());
            for (IndexShard replica : this.replicas) {
                this.recoverReplica(replica);
            }
            this.computeReplicationTargets();
        }

        public IndexShard addReplica() throws IOException {
            ShardRouting replicaRouting = this.createShardRouting("s" + this.replicaId.incrementAndGet(), false);
            IndexShard replica = ESIndexLevelReplicationTestCase.this.newShard(replicaRouting, this.indexMetaData, null, this.getEngineFactory(replicaRouting), () -> {}, new IndexingOperationListener[0]);
            this.addReplica(replica);
            return replica;
        }

        public synchronized void addReplica(IndexShard replica) throws IOException {
            assert (!this.shardRoutings().stream().filter(shardRouting -> shardRouting.isSameAllocation(replica.routingEntry())).findFirst().isPresent()) : "replica with aId [" + replica.routingEntry().allocationId() + "] already exists";
            this.replicas.add(replica);
            if (this.replicationTargets != null) {
                this.replicationTargets.addReplica(replica);
            }
            this.updateAllocationIDsOnPrimary();
        }

        public synchronized IndexShard addReplicaWithExistingPath(ShardPath shardPath, String nodeId) throws IOException {
            ShardRouting shardRouting = TestShardRouting.newShardRouting(ESIndexLevelReplicationTestCase.this.shardId, nodeId, false, ShardRoutingState.INITIALIZING, (RecoverySource)RecoverySource.PeerRecoverySource.INSTANCE);
            IndexShard newReplica = ESIndexLevelReplicationTestCase.this.newShard(shardRouting, shardPath, this.indexMetaData, (CheckedFunction<IndexSettings, Store, IOException>)null, null, this.getEngineFactory(shardRouting), () -> {}, IndexShardTestCase.EMPTY_EVENT_LISTENER, new IndexingOperationListener[0]);
            this.replicas.add(newReplica);
            if (this.replicationTargets != null) {
                this.replicationTargets.addReplica(newReplica);
            }
            this.updateAllocationIDsOnPrimary();
            return newReplica;
        }

        public synchronized List<IndexShard> getReplicas() {
            return Collections.unmodifiableList(this.replicas);
        }

        public Future<PrimaryReplicaSyncer.ResyncTask> promoteReplicaToPrimary(IndexShard replica) throws IOException {
            final PlainActionFuture fut = new PlainActionFuture();
            this.promoteReplicaToPrimary(replica, (shard, listener) -> {
                this.computeReplicationTargets();
                this.primaryReplicaSyncer.resync(shard, (ActionListener)new ActionListener<PrimaryReplicaSyncer.ResyncTask>(){

                    public void onResponse(PrimaryReplicaSyncer.ResyncTask resyncTask) {
                        listener.onResponse((Object)resyncTask);
                        fut.onResponse((Object)resyncTask);
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                        fut.onFailure(e);
                    }
                });
            });
            return fut;
        }

        public synchronized void promoteReplicaToPrimary(IndexShard replica, BiConsumer<IndexShard, ActionListener<PrimaryReplicaSyncer.ResyncTask>> primaryReplicaSyncer) throws IOException {
            long newTerm = this.indexMetaData.primaryTerm(ESIndexLevelReplicationTestCase.this.shardId.id()) + 1L;
            IndexMetaData.Builder newMetaData = IndexMetaData.builder((IndexMetaData)this.indexMetaData).primaryTerm(ESIndexLevelReplicationTestCase.this.shardId.id(), newTerm);
            this.indexMetaData = newMetaData.build();
            Assert.assertTrue((boolean)this.replicas.remove(replica));
            ESIndexLevelReplicationTestCase.this.closeShards(new IndexShard[]{this.primary});
            this.primary = replica;
            assert (this.primary.routingEntry().active()) : "only active replicas can be promoted to primary: " + this.primary.routingEntry();
            ShardRouting primaryRouting = replica.routingEntry().moveActiveReplicaToPrimary();
            IndexShardRoutingTable routingTable = this.routingTable(shr -> shr == replica.routingEntry() ? primaryRouting : shr);
            this.primary.updateShardState(primaryRouting, newTerm, primaryReplicaSyncer, currentClusterStateVersion.incrementAndGet(), this.activeIds(), routingTable, Collections.emptySet());
        }

        private synchronized Set<String> activeIds() {
            return this.shardRoutings().stream().filter(ShardRouting::active).map(ShardRouting::allocationId).map(AllocationId::getId).collect(Collectors.toSet());
        }

        private synchronized IndexShardRoutingTable routingTable(Function<ShardRouting, ShardRouting> transformer) {
            IndexShardRoutingTable.Builder routingTable = new IndexShardRoutingTable.Builder(this.primary.shardId());
            this.shardRoutings().stream().map(transformer).forEach(arg_0 -> ((IndexShardRoutingTable.Builder)routingTable).addShard(arg_0));
            return routingTable.build();
        }

        public synchronized boolean removeReplica(IndexShard replica) throws IOException {
            boolean removed = this.replicas.remove(replica);
            if (removed) {
                this.updateAllocationIDsOnPrimary();
                this.computeReplicationTargets();
            }
            return removed;
        }

        public void recoverReplica(IndexShard replica) throws IOException {
            this.recoverReplica(replica, (r, sourceNode) -> new RecoveryTarget(r, sourceNode, recoveryListener, version -> {}));
        }

        public void recoverReplica(IndexShard replica, BiFunction<IndexShard, DiscoveryNode, RecoveryTarget> targetSupplier) throws IOException {
            this.recoverReplica(replica, targetSupplier, true);
        }

        public void recoverReplica(IndexShard replica, BiFunction<IndexShard, DiscoveryNode, RecoveryTarget> targetSupplier, boolean markAsRecovering) throws IOException {
            IndexShardRoutingTable routingTable = this.routingTable(Function.identity());
            Set<String> inSyncIds = this.activeIds();
            ESIndexLevelReplicationTestCase.this.recoverUnstartedReplica(replica, this.primary, targetSupplier, markAsRecovering, inSyncIds, routingTable);
            ESIndexLevelReplicationTestCase.this.startReplicaAfterRecovery(replica, this.primary, inSyncIds, routingTable);
            this.computeReplicationTargets();
        }

        public synchronized DiscoveryNode getPrimaryNode() {
            return ESIndexLevelReplicationTestCase.this.getDiscoveryNode(this.primary.routingEntry().currentNodeId());
        }

        public Future<Void> asyncRecoverReplica(IndexShard replica, BiFunction<IndexShard, DiscoveryNode, RecoveryTarget> targetSupplier) throws IOException {
            FutureTask<Void> task = new FutureTask<Void>(() -> {
                this.recoverReplica(replica, targetSupplier);
                return null;
            });
            ESIndexLevelReplicationTestCase.this.threadPool.generic().execute(task);
            return task;
        }

        public synchronized void assertAllEqual(int expectedCount) throws IOException {
            Set<String> primaryIds = IndexShardTestCase.getShardDocUIDs(this.primary);
            Assert.assertThat((Object)primaryIds.size(), (Matcher)Matchers.equalTo((Object)expectedCount));
            for (IndexShard replica : this.replicas) {
                Set<String> replicaIds = IndexShardTestCase.getShardDocUIDs(replica);
                HashSet<String> temp = new HashSet<String>(primaryIds);
                temp.removeAll(replicaIds);
                Assert.assertThat((String)(replica.routingEntry() + " is missing docs"), temp, (Matcher)Matchers.empty());
                temp = new HashSet<String>(replicaIds);
                temp.removeAll(primaryIds);
                Assert.assertThat((String)(replica.routingEntry() + " has extra docs"), temp, (Matcher)Matchers.empty());
            }
        }

        public synchronized void refresh(String source) {
            for (IndexShard shard : this) {
                shard.refresh(source);
            }
        }

        public synchronized void flush() {
            FlushRequest request = new FlushRequest(new String[0]);
            for (IndexShard shard : this) {
                shard.flush(request);
            }
        }

        public synchronized List<ShardRouting> shardRoutings() {
            return StreamSupport.stream(this.spliterator(), false).map(IndexShard::routingEntry).collect(Collectors.toList());
        }

        @Override
        public synchronized void close() throws Exception {
            if (!this.closed) {
                this.closed = true;
                try {
                    List<DocIdSeqNoAndTerm> docsOnPrimary = IndexShardTestCase.getDocIdAndSeqNos(this.primary);
                    for (IndexShard replica : this.replicas) {
                        Assert.assertThat((Object)replica.getMaxSeenAutoIdTimestamp(), (Matcher)Matchers.equalTo((Object)this.primary.getMaxSeenAutoIdTimestamp()));
                        Assert.assertThat((Object)replica.getMaxSeqNoOfUpdatesOrDeletes(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(this.primary.getMaxSeqNoOfUpdatesOrDeletes())));
                        Assert.assertThat(IndexShardTestCase.getDocIdAndSeqNos(replica), (Matcher)Matchers.equalTo(docsOnPrimary));
                    }
                }
                catch (AlreadyClosedException alreadyClosedException) {
                    // empty catch block
                }
            } else {
                throw new AlreadyClosedException("too bad");
            }
            ESIndexLevelReplicationTestCase.this.closeShards(this);
        }

        @Override
        public Iterator<IndexShard> iterator() {
            return Iterators.concat((Iterator[])new Iterator[]{this.replicas.iterator(), Collections.singleton(this.primary).iterator()});
        }

        public IndexShard getPrimary() {
            return this.primary;
        }

        public synchronized void reinitPrimaryShard() throws IOException {
            this.primary = ESIndexLevelReplicationTestCase.this.reinitShard(this.primary, new IndexingOperationListener[0]);
            this.computeReplicationTargets();
        }

        public void syncGlobalCheckpoint() {
            PlainActionFuture listener = new PlainActionFuture();
            try {
                new GlobalCheckpointSync((ActionListener<ReplicationResponse>)listener, this).execute();
                listener.get();
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }

        private void updateAllocationIDsOnPrimary() throws IOException {
            this.primary.updateShardState(this.primary.routingEntry(), this.primary.getPendingPrimaryTerm(), null, currentClusterStateVersion.incrementAndGet(), this.activeIds(), this.routingTable(Function.identity()), Collections.emptySet());
        }

        private synchronized void computeReplicationTargets() {
            this.replicationTargets = new ReplicationTargets(this.primary, new ArrayList<IndexShard>(this.replicas));
        }

        private synchronized ReplicationTargets getReplicationTargets() {
            return this.replicationTargets;
        }
    }
}

