/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.test.AbstractBuilderTestCase;
import org.elasticsearch.test.EqualsHashCodeTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public abstract class BaseAggregationTestCase<AB extends AbstractAggregationBuilder<AB>>
extends AbstractBuilderTestCase {
    protected static final String IP_FIELD_NAME = "mapped_ip";

    protected abstract AB createTestAggregatorBuilder();

    public void testFromXContent() throws IOException {
        AB testAgg = this.createTestAggregatorBuilder();
        AggregatorFactories.Builder factoriesBuilder = AggregatorFactories.builder().addAggregator(testAgg);
        XContentBuilder builder = XContentFactory.contentBuilder((XContentType)BaseAggregationTestCase.randomFrom(XContentType.values()));
        if (BaseAggregationTestCase.randomBoolean()) {
            builder.prettyPrint();
        }
        factoriesBuilder.toXContent(builder, ToXContent.EMPTY_PARAMS);
        XContentBuilder shuffled = this.shuffleXContent(builder, new String[0]);
        XContentParser parser = this.createParser(shuffled);
        AggregationBuilder newAgg = this.parse(parser);
        BaseAggregationTestCase.assertNotSame((Object)newAgg, testAgg);
        BaseAggregationTestCase.assertEquals(testAgg, (Object)newAgg);
        BaseAggregationTestCase.assertEquals((long)testAgg.hashCode(), (long)newAgg.hashCode());
    }

    public void testFromXContentMulti() throws IOException {
        AggregatorFactories.Builder factoriesBuilder = AggregatorFactories.builder();
        List<AB> testAggs = this.createTestAggregatorBuilders();
        for (AbstractAggregationBuilder testAgg : testAggs) {
            factoriesBuilder.addAggregator((AggregationBuilder)testAgg);
        }
        XContentBuilder builder = XContentFactory.contentBuilder((XContentType)BaseAggregationTestCase.randomFrom(XContentType.values()));
        if (BaseAggregationTestCase.randomBoolean()) {
            builder.prettyPrint();
        }
        factoriesBuilder.toXContent(builder, ToXContent.EMPTY_PARAMS);
        XContentBuilder shuffled = this.shuffleXContent(builder, new String[0]);
        XContentParser parser = this.createParser(shuffled);
        BaseAggregationTestCase.assertSame((Object)XContentParser.Token.START_OBJECT, (Object)parser.nextToken());
        AggregatorFactories.Builder parsed = AggregatorFactories.parseAggregators((XContentParser)parser);
        BaseAggregationTestCase.assertThat((Object)parsed.getAggregatorFactories(), (Matcher)Matchers.hasSize((int)testAggs.size()));
        BaseAggregationTestCase.assertThat((Object)parsed.getPipelineAggregatorFactories(), (Matcher)Matchers.hasSize((int)0));
        BaseAggregationTestCase.assertEquals((Object)factoriesBuilder, (Object)parsed);
        BaseAggregationTestCase.assertEquals((long)factoriesBuilder.hashCode(), (long)parsed.hashCode());
    }

    public void testSerializationMulti() throws IOException {
        AggregatorFactories.Builder builder = AggregatorFactories.builder();
        List<AB> testAggs = this.createTestAggregatorBuilders();
        for (AbstractAggregationBuilder testAgg : testAggs) {
            builder.addAggregator((AggregationBuilder)testAgg);
        }
        try (BytesStreamOutput output = new BytesStreamOutput();){
            builder.writeTo((StreamOutput)output);
            try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(output.bytes().streamInput(), this.namedWriteableRegistry());){
                AggregatorFactories.Builder newBuilder = new AggregatorFactories.Builder((StreamInput)in);
                BaseAggregationTestCase.assertEquals((Object)builder, (Object)newBuilder);
                BaseAggregationTestCase.assertEquals((long)builder.hashCode(), (long)newBuilder.hashCode());
                BaseAggregationTestCase.assertNotSame((Object)builder, (Object)newBuilder);
            }
        }
    }

    public void testToString() throws IOException {
        AB testAgg = this.createTestAggregatorBuilder();
        String toString = BaseAggregationTestCase.randomBoolean() ? Strings.toString(testAgg) : testAgg.toString();
        XContentParser parser = this.createParser(XContentType.JSON.xContent(), toString);
        AggregationBuilder newAgg = this.parse(parser);
        BaseAggregationTestCase.assertNotSame((Object)newAgg, testAgg);
        BaseAggregationTestCase.assertEquals(testAgg, (Object)newAgg);
        BaseAggregationTestCase.assertEquals((long)testAgg.hashCode(), (long)newAgg.hashCode());
    }

    protected AggregationBuilder parse(XContentParser parser) throws IOException {
        BaseAggregationTestCase.assertSame((Object)XContentParser.Token.START_OBJECT, (Object)parser.nextToken());
        AggregatorFactories.Builder parsed = AggregatorFactories.parseAggregators((XContentParser)parser);
        BaseAggregationTestCase.assertThat((Object)parsed.getAggregatorFactories(), (Matcher)Matchers.hasSize((int)1));
        BaseAggregationTestCase.assertThat((Object)parsed.getPipelineAggregatorFactories(), (Matcher)Matchers.hasSize((int)0));
        AggregationBuilder newAgg = (AggregationBuilder)parsed.getAggregatorFactories().iterator().next();
        BaseAggregationTestCase.assertNull((Object)parser.nextToken());
        BaseAggregationTestCase.assertNotNull((Object)newAgg);
        return newAgg;
    }

    public void testSerialization() throws IOException {
        AB testAgg = this.createTestAggregatorBuilder();
        try (BytesStreamOutput output = new BytesStreamOutput();){
            output.writeNamedWriteable(testAgg);
            try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(output.bytes().streamInput(), this.namedWriteableRegistry());){
                AggregationBuilder deserialized = (AggregationBuilder)in.readNamedWriteable(AggregationBuilder.class);
                BaseAggregationTestCase.assertEquals(testAgg, (Object)deserialized);
                BaseAggregationTestCase.assertEquals((long)testAgg.hashCode(), (long)deserialized.hashCode());
                BaseAggregationTestCase.assertNotSame(testAgg, (Object)deserialized);
            }
        }
    }

    public void testEqualsAndHashcode() throws IOException {
        EqualsHashCodeTestUtils.checkEqualsAndHashCode(this.createTestAggregatorBuilder(), this::copyAggregation);
    }

    public void testShallowCopy() {
        AB original = this.createTestAggregatorBuilder();
        AggregationBuilder clone = original.shallowCopy(((AbstractAggregationBuilder)original).factoriesBuilder, ((AbstractAggregationBuilder)original).metaData);
        BaseAggregationTestCase.assertNotSame(original, (Object)clone);
        BaseAggregationTestCase.assertEquals(original, (Object)clone);
    }

    protected AB copyAggregation(AB agg) throws IOException {
        try (BytesStreamOutput output = new BytesStreamOutput();){
            AbstractAggregationBuilder abstractAggregationBuilder;
            agg.writeTo((StreamOutput)output);
            try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(output.bytes().streamInput(), this.namedWriteableRegistry());){
                AbstractAggregationBuilder secondAgg;
                abstractAggregationBuilder = secondAgg = (AbstractAggregationBuilder)this.namedWriteableRegistry().getReader(AggregationBuilder.class, agg.getWriteableName()).read((StreamInput)in);
            }
            return (AB)abstractAggregationBuilder;
        }
    }

    public String randomNumericField() {
        int randomInt = BaseAggregationTestCase.randomInt(3);
        switch (randomInt) {
            case 0: {
                return "mapped_date";
            }
            case 1: {
                return "mapped_double";
            }
        }
        return "mapped_int";
    }

    protected void randomFieldOrScript(ValuesSourceAggregationBuilder<?, ?> factory, String field) {
        int choice = BaseAggregationTestCase.randomInt(2);
        switch (choice) {
            case 0: {
                factory.field(field);
                break;
            }
            case 1: {
                factory.field(field);
                factory.script(BaseAggregationTestCase.mockScript("_value + 1"));
                break;
            }
            case 2: {
                factory.script(BaseAggregationTestCase.mockScript("doc[" + field + "] + 1"));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknow random operation [" + choice + "]"));
            }
        }
    }

    private List<AB> createTestAggregatorBuilders() {
        int numberOfAggregatorBuilders = BaseAggregationTestCase.randomIntBetween(2, 10);
        HashSet<String> names = new HashSet<String>();
        ArrayList<AB> aggBuilders = new ArrayList<AB>();
        while (names.size() < numberOfAggregatorBuilders) {
            AB aggBuilder = this.createTestAggregatorBuilder();
            if (!names.add(aggBuilder.getName())) continue;
            aggBuilders.add(aggBuilder);
        }
        return aggBuilders;
    }
}

