/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.annotations.Listeners;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakLingering;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakScope;
import com.carrotsearch.randomizedtesting.annotations.TimeoutSuite;
import com.carrotsearch.randomizedtesting.generators.CodepointSetGenerator;
import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.carrotsearch.randomizedtesting.generators.RandomStrings;
import com.carrotsearch.randomizedtesting.rules.TestRuleAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.Security;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.status.StatusConsoleListener;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestRuleMarkFailure;
import org.apache.lucene.util.TestUtil;
import org.elasticsearch.Version;
import org.elasticsearch.bootstrap.BootstrapForTesting;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.common.CheckedBiFunction;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.io.PathUtilsForTesting;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.LogConfigurator;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.MockBigArrays;
import org.elasticsearch.common.util.MockPageCacheRecycler;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.TestEnvironment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.script.MockScriptEngine;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptModule;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.MockSearchService;
import org.elasticsearch.test.IndexSettingsModule;
import org.elasticsearch.test.NotEqualMessageBuilder;
import org.elasticsearch.test.junit.listeners.LoggingListener;
import org.elasticsearch.test.junit.listeners.ReproduceInfoPrinter;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.MockTcpTransportPlugin;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTimeZone;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@Listeners(value={ReproduceInfoPrinter.class, LoggingListener.class})
@ThreadLeakScope(value=ThreadLeakScope.Scope.SUITE)
@ThreadLeakLingering(linger=5000)
@TimeoutSuite(millis=1200000)
@LuceneTestCase.SuppressSysoutChecks(bugUrl="we log a lot on purpose")
@LuceneTestCase.SuppressCodecs(value={"SimpleText", "Memory", "CheapBastard", "Direct", "Compressing", "FST50", "FSTOrd50", "TestBloomFilteredLucenePostings", "MockRandom", "BlockTreeOrds", "LuceneFixedGap", "LuceneVarGapFixedInterval", "LuceneVarGapDocFreqInterval", "Lucene50"})
@LuceneTestCase.SuppressReproduceLine
public abstract class ESTestCase
extends LuceneTestCase {
    protected static final List<String> JODA_TIMEZONE_IDS;
    protected static final List<String> JAVA_TIMEZONE_IDS;
    protected static final List<String> JAVA_ZONE_IDS;
    private static final AtomicInteger portGenerator;
    private static final Collection<String> nettyLoggedLeaks;
    protected final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    protected final DeprecationLogger deprecationLogger = new DeprecationLogger(this.logger);
    private ThreadContext threadContext;
    @Rule
    public RuleChain failureAndSuccessEvents = RuleChain.outerRule((TestRule)new TestRuleAdapter(){

        protected void afterIfSuccessful() throws Throwable {
            ESTestCase.this.afterIfSuccessful();
        }

        protected void afterAlways(List<Throwable> errors) throws Throwable {
            if (errors != null && !errors.isEmpty()) {
                boolean allAssumption = true;
                for (Throwable error : errors) {
                    if (error instanceof AssumptionViolatedException) continue;
                    allAssumption = false;
                    break;
                }
                if (!allAssumption) {
                    ESTestCase.this.afterIfFailed(errors);
                }
            }
            super.afterAlways(errors);
        }
    });
    private static final List<StatusData> statusData;
    public static boolean checkIndexFailed;
    private static final String[] TIME_SUFFIXES;
    private static final long AWAIT_BUSY_THRESHOLD = 1000L;
    private static final GeohashGenerator geohashGenerator;

    @AfterClass
    public static void resetPortCounter() {
        portGenerator.set(0);
    }

    @SuppressForbidden(reason="force log4j and netty sysprops")
    private static void setTestSysProps() {
        System.setProperty("log4j.shutdownHookEnabled", "false");
        System.setProperty("log4j2.disable.jmx", "true");
        System.setProperty("io.netty.leakDetection.level", "paranoid");
    }

    public static TransportAddress buildNewFakeTransportAddress() {
        return new TransportAddress(TransportAddress.META_ADDRESS, portGenerator.incrementAndGet());
    }

    protected void afterIfFailed(List<Throwable> errors) {
    }

    protected void afterIfSuccessful() throws Exception {
    }

    @BeforeClass
    public static void setFileSystem() throws Exception {
        PathUtilsForTesting.setup();
    }

    @AfterClass
    public static void restoreFileSystem() throws Exception {
        PathUtilsForTesting.teardown();
    }

    @BeforeClass
    public static void setContentType() throws Exception {
        Requests.CONTENT_TYPE = ESTestCase.randomFrom(XContentType.values());
        Requests.INDEX_CONTENT_TYPE = ESTestCase.randomFrom(XContentType.values());
    }

    @AfterClass
    public static void restoreContentType() {
        Requests.CONTENT_TYPE = XContentType.SMILE;
        Requests.INDEX_CONTENT_TYPE = XContentType.JSON;
    }

    @Before
    public final void before() {
        this.logger.info("{}before test", (Object)this.getTestParamsForLogging());
        ESTestCase.assertNull((String)"Thread context initialized twice", (Object)this.threadContext);
        if (this.enableWarningsCheck()) {
            this.threadContext = new ThreadContext(Settings.EMPTY);
            DeprecationLogger.setThreadContext((ThreadContext)this.threadContext);
        }
    }

    protected boolean enableWarningsCheck() {
        return true;
    }

    @After
    public final void after() throws Exception {
        ESTestCase.checkStaticState(false);
        if (this.threadContext != null) {
            this.ensureNoWarnings();
            assert (this.threadContext == null);
        }
        this.ensureAllSearchContextsReleased();
        this.ensureCheckIndexPassed();
        this.logger.info("{}after test", (Object)this.getTestParamsForLogging());
    }

    private String getTestParamsForLogging() {
        String name = this.getTestName();
        int start = name.indexOf(123);
        if (start < 0) {
            return "";
        }
        int end = name.lastIndexOf(125);
        if (end < 0) {
            return "";
        }
        return "[" + name.substring(start + 1, end) + "] ";
    }

    private void ensureNoWarnings() throws IOException {
        try {
            List warnings = (List)this.threadContext.getResponseHeaders().get("Warning");
            ESTestCase.assertNull((String)"unexpected warning headers", (Object)warnings);
        }
        finally {
            this.resetDeprecationLogger(false);
        }
    }

    protected final void assertSettingDeprecationsAndWarnings(Setting<?>[] settings, String ... warnings) {
        this.assertSettingDeprecationsAndWarnings((String[])Arrays.stream(settings).map(Setting::getKey).toArray(String[]::new), warnings);
    }

    protected final void assertSettingDeprecationsAndWarnings(String[] settings, String ... warnings) {
        this.assertWarnings((String[])Stream.concat(Arrays.stream(settings).map(k -> "[" + k + "] setting was deprecated in Elasticsearch and will be removed in a future release! See the breaking changes documentation for the next major version."), Arrays.stream(warnings)).toArray(String[]::new));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void assertWarnings(String ... expectedWarnings) {
        if (!this.enableWarningsCheck()) {
            throw new IllegalStateException("unable to check warning headers if the test is not set to do so");
        }
        try {
            List actualWarnings = (List)this.threadContext.getResponseHeaders().get("Warning");
            ESTestCase.assertNotNull((String)("no warnings, expected: " + Arrays.asList(expectedWarnings)), (Object)actualWarnings);
            Set actualWarningValues = actualWarnings.stream().map(DeprecationLogger::extractWarningValueFromWarningHeader).collect(Collectors.toSet());
            for (String msg : expectedWarnings) {
                ESTestCase.assertThat(actualWarningValues, (Matcher)Matchers.hasItem((Object)DeprecationLogger.escapeAndEncode((String)msg)));
            }
            ESTestCase.assertEquals((String)("Expected " + expectedWarnings.length + " warnings but found " + actualWarnings.size() + "\nExpected: " + Arrays.asList(expectedWarnings) + "\nActual: " + actualWarnings), (long)expectedWarnings.length, (long)actualWarnings.size());
        }
        finally {
            this.resetDeprecationLogger(true);
        }
    }

    private void resetDeprecationLogger(boolean setNewThreadContext) {
        DeprecationLogger.removeThreadContext((ThreadContext)this.threadContext);
        try {
            this.threadContext.close();
        }
        catch (IOException ex) {
            throw new AssertionError("IOException thrown while closing deprecation logger's thread context", ex);
        }
        if (setNewThreadContext) {
            this.threadContext = new ThreadContext(Settings.EMPTY);
            DeprecationLogger.setThreadContext((ThreadContext)this.threadContext);
        } else {
            this.threadContext = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkStaticState(boolean afterClass) throws Exception {
        if (afterClass) {
            MockPageCacheRecycler.ensureAllPagesAreReleased();
        }
        MockBigArrays.ensureAllArraysAreReleased();
        ESTestCase.assertThat((Object)StatusLogger.getLogger().getLevel(), (Matcher)Matchers.equalTo((Object)Level.WARN));
        Collection<Object> collection = statusData;
        synchronized (collection) {
            try {
                ESTestCase.assertThat(statusData.stream().map(status -> status.getMessage().getFormattedMessage()).collect(Collectors.toList()), (Matcher)Matchers.empty());
            }
            finally {
                statusData.clear();
            }
        }
        collection = nettyLoggedLeaks;
        synchronized (collection) {
            try {
                ESTestCase.assertThat(nettyLoggedLeaks, (Matcher)Matchers.empty());
            }
            finally {
                nettyLoggedLeaks.clear();
            }
        }
    }

    public final void ensureAllSearchContextsReleased() throws Exception {
        ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> MockSearchService.assertNoInFlightContext()));
    }

    @Before
    public final void resetCheckIndexStatus() throws Exception {
        checkIndexFailed = false;
    }

    public final void ensureCheckIndexPassed() throws Exception {
        ESTestCase.assertFalse((String)"at least one shard failed CheckIndex", (boolean)checkIndexFailed);
    }

    public static int scaledRandomIntBetween(int min, int max) {
        return RandomizedTest.scaledRandomIntBetween((int)min, (int)max);
    }

    public static int randomIntBetween(int min, int max) {
        return RandomNumbers.randomIntBetween((Random)ESTestCase.random(), (int)min, (int)max);
    }

    public static long randomLongBetween(long min, long max) {
        return RandomNumbers.randomLongBetween((Random)ESTestCase.random(), (long)min, (long)max);
    }

    public static int iterations(int min, int max) {
        return ESTestCase.scaledRandomIntBetween(min, max);
    }

    public static int between(int min, int max) {
        return ESTestCase.randomIntBetween(min, max);
    }

    public static boolean frequently() {
        return !ESTestCase.rarely();
    }

    public static boolean randomBoolean() {
        return ESTestCase.random().nextBoolean();
    }

    public static byte randomByte() {
        return (byte)ESTestCase.random().nextInt();
    }

    public static byte[] randomByteArrayOfLength(int size) {
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            bytes[i] = ESTestCase.randomByte();
        }
        return bytes;
    }

    public static short randomShort() {
        return (short)ESTestCase.random().nextInt();
    }

    public static int randomInt() {
        return ESTestCase.random().nextInt();
    }

    public static long randomNonNegativeLong() {
        long randomLong = ESTestCase.randomLong();
        return randomLong == Long.MIN_VALUE ? 0L : Math.abs(randomLong);
    }

    public static float randomFloat() {
        return ESTestCase.random().nextFloat();
    }

    public static double randomDouble() {
        return ESTestCase.random().nextDouble();
    }

    public static double randomDoubleBetween(double start, double end, boolean lowerInclusive) {
        double result = 0.0;
        if (start == -1.7976931348623157E308 || end == Double.MAX_VALUE) {
            result = Double.longBitsToDouble(ESTestCase.randomLong());
            while (result < start || result > end || Double.isNaN(result)) {
                result = Double.longBitsToDouble(ESTestCase.randomLong());
            }
        } else {
            result = ESTestCase.randomDouble();
            if (!lowerInclusive) {
                while (result <= 0.0) {
                    result = ESTestCase.randomDouble();
                }
            }
            result = result * end + (1.0 - result) * start;
        }
        return result;
    }

    public static long randomLong() {
        return ESTestCase.random().nextLong();
    }

    public static int randomInt(int max) {
        return RandomizedTest.randomInt((int)max);
    }

    public static <T> T randomFrom(T ... array) {
        return ESTestCase.randomFrom(ESTestCase.random(), array);
    }

    public static <T> T randomFrom(Random random, T ... array) {
        return (T)RandomPicks.randomFrom((Random)random, (Object[])array);
    }

    public static <T> T randomFrom(List<T> list) {
        return (T)RandomPicks.randomFrom((Random)ESTestCase.random(), list);
    }

    public static <T> T randomFrom(Collection<T> collection) {
        return ESTestCase.randomFrom(ESTestCase.random(), collection);
    }

    public static <T> T randomFrom(Random random, Collection<T> collection) {
        return (T)RandomPicks.randomFrom((Random)random, collection);
    }

    public static String randomAlphaOfLengthBetween(int minCodeUnits, int maxCodeUnits) {
        return RandomizedTest.randomAsciiOfLengthBetween((int)minCodeUnits, (int)maxCodeUnits);
    }

    public static String randomAlphaOfLength(int codeUnits) {
        return RandomizedTest.randomAsciiOfLength((int)codeUnits);
    }

    public static String randomUnicodeOfLengthBetween(int minCodeUnits, int maxCodeUnits) {
        return RandomizedTest.randomUnicodeOfLengthBetween((int)minCodeUnits, (int)maxCodeUnits);
    }

    public static String randomUnicodeOfLength(int codeUnits) {
        return RandomizedTest.randomUnicodeOfLength((int)codeUnits);
    }

    public static String randomUnicodeOfCodepointLengthBetween(int minCodePoints, int maxCodePoints) {
        return RandomizedTest.randomUnicodeOfCodepointLengthBetween((int)minCodePoints, (int)maxCodePoints);
    }

    public static String randomUnicodeOfCodepointLength(int codePoints) {
        return RandomizedTest.randomUnicodeOfCodepointLength((int)codePoints);
    }

    public static String randomRealisticUnicodeOfLengthBetween(int minCodeUnits, int maxCodeUnits) {
        return RandomizedTest.randomRealisticUnicodeOfLengthBetween((int)minCodeUnits, (int)maxCodeUnits);
    }

    public static String randomRealisticUnicodeOfLength(int codeUnits) {
        return RandomizedTest.randomRealisticUnicodeOfLength((int)codeUnits);
    }

    public static String randomRealisticUnicodeOfCodepointLengthBetween(int minCodePoints, int maxCodePoints) {
        return RandomizedTest.randomRealisticUnicodeOfCodepointLengthBetween((int)minCodePoints, (int)maxCodePoints);
    }

    public static String randomRealisticUnicodeOfCodepointLength(int codePoints) {
        return RandomizedTest.randomRealisticUnicodeOfCodepointLength((int)codePoints);
    }

    public static String[] generateRandomStringArray(int maxArraySize, int stringSize, boolean allowNull, boolean allowEmpty) {
        if (allowNull && ESTestCase.random().nextBoolean()) {
            return null;
        }
        int arraySize = ESTestCase.randomIntBetween(allowEmpty ? 0 : 1, maxArraySize);
        String[] array = new String[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            array[i] = RandomStrings.randomAsciiOfLength((Random)ESTestCase.random(), (int)stringSize);
        }
        return array;
    }

    public static String[] generateRandomStringArray(int maxArraySize, int stringSize, boolean allowNull) {
        return ESTestCase.generateRandomStringArray(maxArraySize, stringSize, allowNull, true);
    }

    public static <T> T[] randomArray(int maxArraySize, IntFunction<T[]> arrayConstructor, Supplier<T> valueConstructor) {
        return ESTestCase.randomArray(0, maxArraySize, arrayConstructor, valueConstructor);
    }

    public static <T> T[] randomArray(int minArraySize, int maxArraySize, IntFunction<T[]> arrayConstructor, Supplier<T> valueConstructor) {
        int size = ESTestCase.randomIntBetween(minArraySize, maxArraySize);
        T[] array = arrayConstructor.apply(size);
        for (int i = 0; i < array.length; ++i) {
            array[i] = valueConstructor.get();
        }
        return array;
    }

    public static String randomTimeValue(int lower, int upper, String ... suffixes) {
        return ESTestCase.randomIntBetween(lower, upper) + ESTestCase.randomFrom(suffixes);
    }

    public static String randomTimeValue(int lower, int upper) {
        return ESTestCase.randomTimeValue(lower, upper, TIME_SUFFIXES);
    }

    public static String randomTimeValue() {
        return ESTestCase.randomTimeValue(0, 1000);
    }

    public static String randomPositiveTimeValue() {
        return ESTestCase.randomTimeValue(1, 1000);
    }

    public static DateTimeZone randomDateTimeZone() {
        return DateTimeZone.forID((String)ESTestCase.randomFrom(JODA_TIMEZONE_IDS));
    }

    public static TimeZone randomTimeZone() {
        return TimeZone.getTimeZone(ESTestCase.randomFrom(JAVA_TIMEZONE_IDS));
    }

    public static ZoneId randomZone() {
        return ZoneId.of(ESTestCase.randomFrom(JAVA_ZONE_IDS));
    }

    public static <T> void maybeSet(Consumer<T> consumer, T value) {
        if (ESTestCase.randomBoolean()) {
            consumer.accept(value);
        }
    }

    public static <T> T randomValueOtherThan(T input, Supplier<T> randomSupplier) {
        return (T)ESTestCase.randomValueOtherThanMany(v -> Objects.equals(input, v), randomSupplier);
    }

    public static <T> T randomValueOtherThanMany(Predicate<T> input, Supplier<T> randomSupplier) {
        T randomValue = null;
        while (input.test(randomValue = (T)randomSupplier.get())) {
        }
        return randomValue;
    }

    public static void assertBusy(CheckedRunnable<Exception> codeBlock) throws Exception {
        ESTestCase.assertBusy(codeBlock, 10L, TimeUnit.SECONDS);
    }

    public static void assertBusy(CheckedRunnable<Exception> codeBlock, long maxWaitTime, TimeUnit unit) throws Exception {
        long maxTimeInMillis = TimeUnit.MILLISECONDS.convert(maxWaitTime, unit);
        long iterations = Math.max(Math.round(Math.log10(maxTimeInMillis) / Math.log10(2.0)), 1L);
        long timeInMillis = 1L;
        long sum = 0L;
        ArrayList<AssertionError> failures = new ArrayList<AssertionError>();
        int i = 0;
        while ((long)i < iterations) {
            try {
                codeBlock.run();
                return;
            }
            catch (AssertionError e) {
                failures.add(e);
                sum += timeInMillis;
                Thread.sleep(timeInMillis);
                timeInMillis *= 2L;
                ++i;
            }
        }
        timeInMillis = maxTimeInMillis - sum;
        Thread.sleep(Math.max(timeInMillis, 0L));
        try {
            codeBlock.run();
        }
        catch (AssertionError e) {
            for (AssertionError failure : failures) {
                ((Throwable)((Object)e)).addSuppressed((Throwable)((Object)failure));
            }
            throw e;
        }
    }

    public static boolean awaitBusy(BooleanSupplier breakSupplier) throws InterruptedException {
        return ESTestCase.awaitBusy(breakSupplier, 10L, TimeUnit.SECONDS);
    }

    public static boolean awaitBusy(BooleanSupplier breakSupplier, long maxWaitTime, TimeUnit unit) throws InterruptedException {
        long maxTimeInMillis = TimeUnit.MILLISECONDS.convert(maxWaitTime, unit);
        long timeInMillis = 1L;
        long sum = 0L;
        while (sum + timeInMillis < maxTimeInMillis) {
            if (breakSupplier.getAsBoolean()) {
                return true;
            }
            Thread.sleep(timeInMillis);
            sum += timeInMillis;
            timeInMillis = Math.min(1000L, timeInMillis * 2L);
        }
        timeInMillis = maxTimeInMillis - sum;
        Thread.sleep(Math.max(timeInMillis, 0L));
        return breakSupplier.getAsBoolean();
    }

    public static boolean terminate(ExecutorService ... services) throws InterruptedException {
        boolean terminated = true;
        for (ExecutorService service : services) {
            if (service == null) continue;
            terminated &= ThreadPool.terminate((ExecutorService)service, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
        return terminated;
    }

    public static boolean terminate(ThreadPool threadPool) throws InterruptedException {
        return ThreadPool.terminate((ThreadPool)threadPool, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    public Path getDataPath(String relativePath) {
        try {
            return PathUtils.get((URI)((Object)((Object)this)).getClass().getResource(relativePath).toURI());
        }
        catch (Exception e) {
            throw new RuntimeException("resource not found: " + relativePath, e);
        }
    }

    public Path getBwcIndicesPath() {
        return this.getDataPath("/indices/bwc");
    }

    public String[] tmpPaths() {
        int numPaths = TestUtil.nextInt((Random)ESTestCase.random(), (int)1, (int)3);
        String[] absPaths = new String[numPaths];
        for (int i = 0; i < numPaths; ++i) {
            absPaths[i] = ESTestCase.createTempDir().toAbsolutePath().toString();
        }
        return absPaths;
    }

    public NodeEnvironment newNodeEnvironment() throws IOException {
        return this.newNodeEnvironment(Settings.EMPTY);
    }

    public NodeEnvironment newNodeEnvironment(Settings settings) throws IOException {
        Settings build = Settings.builder().put(settings).put(Environment.PATH_HOME_SETTING.getKey(), ESTestCase.createTempDir().toAbsolutePath()).putList(Environment.PATH_DATA_SETTING.getKey(), this.tmpPaths()).build();
        return new NodeEnvironment(build, TestEnvironment.newEnvironment(build), nodeId -> {});
    }

    public static Settings.Builder settings(Version version) {
        Settings.Builder builder = Settings.builder().put("index.version.created", version);
        return builder;
    }

    private static String threadName(Thread t) {
        return "Thread[id=" + t.getId() + ", name=" + t.getName() + ", state=" + (Object)((Object)t.getState()) + ", group=" + ESTestCase.groupName(t.getThreadGroup()) + "]";
    }

    private static String groupName(ThreadGroup threadGroup) {
        if (threadGroup == null) {
            return "{null group}";
        }
        return threadGroup.getName();
    }

    public static <T> List<T> randomSubsetOf(int size, T ... values) {
        ArrayList list = CollectionUtils.arrayAsArrayList((Object[])values);
        return ESTestCase.randomSubsetOf(size, list);
    }

    public static <T> List<T> randomSubsetOf(Collection<T> collection) {
        return ESTestCase.randomSubsetOf(ESTestCase.randomInt(Math.max(collection.size() - 1, 0)), collection);
    }

    public static <T> List<T> randomSubsetOf(int size, Collection<T> collection) {
        if (size > collection.size()) {
            throw new IllegalArgumentException("Can't pick " + size + " random objects from a collection of " + collection.size() + " objects");
        }
        ArrayList<T> tempList = new ArrayList<T>(collection);
        Collections.shuffle(tempList, ESTestCase.random());
        return tempList.subList(0, size);
    }

    public static <T> Set<T> randomUnique(Supplier<T> supplier, int targetCount) {
        HashSet<T> things = new HashSet<T>();
        int maxTries = targetCount * 10;
        for (int t = 0; t < maxTries; ++t) {
            if (things.size() == targetCount) {
                return things;
            }
            things.add(supplier.get());
        }
        return things;
    }

    public static String randomGeohash(int minPrecision, int maxPrecision) {
        return geohashGenerator.ofStringLength(ESTestCase.random(), minPrecision, maxPrecision);
    }

    public static String getTestTransportType() {
        return "mock-socket-network";
    }

    public static Class<? extends Plugin> getTestTransportPlugin() {
        return MockTcpTransportPlugin.class;
    }

    protected final BytesReference toShuffledXContent(ToXContent toXContent, XContentType xContentType, ToXContent.Params params, boolean humanReadable, String ... exceptFieldNames) throws IOException {
        return ESTestCase.toShuffledXContent(toXContent, xContentType, params, humanReadable, (CheckedBiFunction<XContent, BytesReference, XContentParser, IOException>)((CheckedBiFunction)this::createParser), exceptFieldNames);
    }

    protected static BytesReference toShuffledXContent(ToXContent toXContent, XContentType xContentType, ToXContent.Params params, boolean humanReadable, CheckedBiFunction<XContent, BytesReference, XContentParser, IOException> parserFunction, String ... exceptFieldNames) throws IOException {
        BytesReference bytes = XContentHelper.toXContent((ToXContent)toXContent, (XContentType)xContentType, (ToXContent.Params)params, (boolean)humanReadable);
        try (XContentParser parser = (XContentParser)parserFunction.apply((Object)xContentType.xContent(), (Object)bytes);){
            BytesReference bytesReference;
            block12: {
                XContentBuilder builder = ESTestCase.shuffleXContent(parser, ESTestCase.rarely(), exceptFieldNames);
                try {
                    bytesReference = BytesReference.bytes((XContentBuilder)builder);
                    if (builder == null) break block12;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return bytesReference;
        }
    }

    protected final XContentBuilder shuffleXContent(XContentBuilder builder, String ... exceptFieldNames) throws IOException {
        try (XContentParser parser = this.createParser(builder);){
            XContentBuilder xContentBuilder = ESTestCase.shuffleXContent(parser, builder.isPrettyPrint(), exceptFieldNames);
            return xContentBuilder;
        }
    }

    public static XContentBuilder shuffleXContent(XContentParser parser, boolean prettyPrint, String ... exceptFieldNames) throws IOException {
        XContentParser.Token token;
        XContentBuilder xContentBuilder = XContentFactory.contentBuilder((XContentType)parser.contentType());
        if (prettyPrint) {
            xContentBuilder.prettyPrint();
        }
        XContentParser.Token token2 = token = parser.currentToken() == null ? parser.nextToken() : parser.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            List<Object> shuffledList = ESTestCase.shuffleList(parser.listOrderedMap(), new HashSet<String>(Arrays.asList(exceptFieldNames)));
            return xContentBuilder.value(shuffledList);
        }
        LinkedHashMap<String, Object> shuffledMap = ESTestCase.shuffleMap((LinkedHashMap)parser.mapOrdered(), new HashSet<String>(Arrays.asList(exceptFieldNames)));
        return xContentBuilder.map(shuffledMap);
    }

    private static List<Object> shuffleList(List<Object> list, Set<String> exceptFields) {
        ArrayList<Object> targetList = new ArrayList<Object>();
        for (Object value : list) {
            if (value instanceof Map) {
                LinkedHashMap valueMap = (LinkedHashMap)value;
                targetList.add(ESTestCase.shuffleMap(valueMap, exceptFields));
                continue;
            }
            if (value instanceof List) {
                targetList.add(ESTestCase.shuffleList((List)value, exceptFields));
                continue;
            }
            targetList.add(value);
        }
        return targetList;
    }

    public static LinkedHashMap<String, Object> shuffleMap(LinkedHashMap<String, Object> map, Set<String> exceptFields) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        LinkedHashMap<String, Object> targetMap = new LinkedHashMap<String, Object>();
        Collections.shuffle(keys, ESTestCase.random());
        for (String key : keys) {
            Object value = map.get(key);
            if (value instanceof Map && !exceptFields.contains(key)) {
                LinkedHashMap valueMap = (LinkedHashMap)value;
                targetMap.put(key, ESTestCase.shuffleMap(valueMap, exceptFields));
                continue;
            }
            if (value instanceof List && !exceptFields.contains(key)) {
                targetMap.put(key, ESTestCase.shuffleList((List)value, exceptFields));
                continue;
            }
            targetMap.put(key, value);
        }
        return targetMap;
    }

    public static <T extends Writeable> T copyWriteable(T original, NamedWriteableRegistry namedWriteableRegistry, Writeable.Reader<T> reader) throws IOException {
        return ESTestCase.copyWriteable(original, namedWriteableRegistry, reader, Version.CURRENT);
    }

    public static <T extends Writeable> T copyWriteable(T original, NamedWriteableRegistry namedWriteableRegistry, Writeable.Reader<T> reader, Version version) throws IOException {
        return ESTestCase.copyInstance(original, namedWriteableRegistry, (out, value) -> value.writeTo(out), reader, version);
    }

    public static <T extends Streamable> T copyStreamable(T original, NamedWriteableRegistry namedWriteableRegistry, Supplier<T> supplier, Version version) throws IOException {
        return ESTestCase.copyInstance(original, namedWriteableRegistry, (out, value) -> value.writeTo(out), Streamable.newWriteableReader(supplier), version);
    }

    protected static <T> T copyInstance(T original, NamedWriteableRegistry namedWriteableRegistry, Writeable.Writer<T> writer, Writeable.Reader<T> reader, Version version) throws IOException {
        try (BytesStreamOutput output = new BytesStreamOutput();){
            Object object;
            output.setVersion(version);
            writer.write((StreamOutput)output, original);
            try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(output.bytes().streamInput(), namedWriteableRegistry);){
                in.setVersion(version);
                object = reader.read((StreamInput)in);
            }
            return (T)object;
        }
    }

    public void assertAllIndicesRemovedAndDeletionCompleted(Iterable<IndicesService> indicesServices) throws Exception {
        for (IndicesService indicesService : indicesServices) {
            ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> ESTestCase.assertFalse((boolean)indicesService.iterator().hasNext())), 1L, TimeUnit.MINUTES);
            ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> ESTestCase.assertFalse((boolean)indicesService.hasUncompletedPendingDeletes())), 1L, TimeUnit.MINUTES);
        }
    }

    public void assertPathHasBeenCleared(Path path) {
        this.logger.info("--> checking that [{}] has been cleared", (Object)path);
        int count = 0;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (Files.exists(path, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                for (Path file : stream) {
                    if (file.getFileName().toString().startsWith("extra")) continue;
                    this.logger.info("--> found file: [{}]", (Object)file.toAbsolutePath().toString());
                    if (Files.isDirectory(file, new LinkOption[0])) {
                        this.assertPathHasBeenCleared(file);
                        continue;
                    }
                    if (!Files.isRegularFile(file, new LinkOption[0])) continue;
                    ++count;
                    sb.append(file.toAbsolutePath().toString());
                    sb.append("\n");
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        sb.append("]");
        ESTestCase.assertThat((String)(count + " files exist that should have been cleaned:\n" + sb.toString()), (Object)count, (Matcher)Matchers.equalTo((Object)0));
    }

    public static <T extends ToXContent> void assertEqualsWithErrorMessageFromXContent(T expected, T actual) {
        if (Objects.equals(expected, actual)) {
            return;
        }
        if (expected == null) {
            throw new AssertionError((Object)("Expected null be actual was [" + actual.toString() + "]"));
        }
        if (actual == null) {
            throw new AssertionError((Object)"Didn't expect null but actual was [null]");
        }
        try {
            XContentBuilder actualJson = JsonXContent.contentBuilder();
            try {
                XContentBuilder expectedJson = JsonXContent.contentBuilder();
                try {
                    actualJson.startObject();
                    actual.toXContent(actualJson, ToXContent.EMPTY_PARAMS);
                    actualJson.endObject();
                    expectedJson.startObject();
                    expected.toXContent(expectedJson, ToXContent.EMPTY_PARAMS);
                    expectedJson.endObject();
                    NotEqualMessageBuilder message = new NotEqualMessageBuilder();
                    message.compareMaps((Map)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)actualJson), (boolean)false).v2(), (Map)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)expectedJson), (boolean)false).v2());
                    throw new AssertionError((Object)("Didn't match expected value:\n" + message));
                }
                catch (Throwable throwable) {
                    if (expectedJson != null) {
                        try {
                            expectedJson.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (actualJson != null) {
                    try {
                        actualJson.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new AssertionError("IOException while building failure message", e);
        }
    }

    protected final XContentParser createParser(XContentBuilder builder) throws IOException {
        return builder.generator().contentType().xContent().createParser(this.xContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)BytesReference.bytes((XContentBuilder)builder).streamInput());
    }

    protected final XContentParser createParser(XContent xContent, String data) throws IOException {
        return xContent.createParser(this.xContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, data);
    }

    protected final XContentParser createParser(XContent xContent, InputStream data) throws IOException {
        return xContent.createParser(this.xContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, data);
    }

    protected final XContentParser createParser(XContent xContent, byte[] data) throws IOException {
        return xContent.createParser(this.xContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, data);
    }

    protected final XContentParser createParser(XContent xContent, BytesReference data) throws IOException {
        return xContent.createParser(this.xContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)data.streamInput());
    }

    protected NamedXContentRegistry xContentRegistry() {
        return new NamedXContentRegistry(ClusterModule.getNamedXWriteables());
    }

    protected NamedWriteableRegistry writableRegistry() {
        return new NamedWriteableRegistry(ClusterModule.getNamedWriteables());
    }

    public static final Script mockScript(String id) {
        return new Script(ScriptType.INLINE, "mockscript", id, Collections.emptyMap());
    }

    public static TestRuleMarkFailure getSuiteFailureMarker() {
        return suiteFailureMarker;
    }

    public static void assertArrayEquals(StackTraceElement[] expected, StackTraceElement[] actual) {
        ESTestCase.assertEquals((long)expected.length, (long)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            ESTestCase.assertEquals(expected[i], actual[i]);
        }
    }

    public static void assertEquals(StackTraceElement expected, StackTraceElement actual) {
        ESTestCase.assertEquals((Object)expected.getClassName(), (Object)actual.getClassName());
        ESTestCase.assertEquals((Object)expected.getMethodName(), (Object)actual.getMethodName());
        ESTestCase.assertEquals((Object)expected.getFileName(), (Object)actual.getFileName());
        ESTestCase.assertEquals((long)expected.getLineNumber(), (long)actual.getLineNumber());
        ESTestCase.assertEquals((Object)expected.isNativeMethod(), (Object)actual.isNativeMethod());
    }

    protected static long spinForAtLeastOneMillisecond() {
        return ESTestCase.spinForAtLeastNMilliseconds(1L);
    }

    protected static long spinForAtLeastNMilliseconds(long ms) {
        long elapsed;
        long nanosecondsInMillisecond = TimeUnit.NANOSECONDS.convert(ms, TimeUnit.MILLISECONDS);
        long start = System.nanoTime();
        while ((elapsed = System.nanoTime() - start) < nanosecondsInMillisecond) {
        }
        return elapsed;
    }

    public static TestAnalysis createTestAnalysis(Index index, Settings settings, AnalysisPlugin ... analysisPlugins) throws IOException {
        Settings nodeSettings = Settings.builder().put(Environment.PATH_HOME_SETTING.getKey(), ESTestCase.createTempDir()).build();
        return ESTestCase.createTestAnalysis(index, nodeSettings, settings, analysisPlugins);
    }

    public static TestAnalysis createTestAnalysis(Index index, Settings nodeSettings, Settings settings, AnalysisPlugin ... analysisPlugins) throws IOException {
        Settings indexSettings = Settings.builder().put(settings).put("index.version.created", Version.CURRENT).build();
        return ESTestCase.createTestAnalysis(IndexSettingsModule.newIndexSettings(index, indexSettings, new Setting[0]), nodeSettings, analysisPlugins);
    }

    public static TestAnalysis createTestAnalysis(IndexSettings indexSettings, Settings nodeSettings, AnalysisPlugin ... analysisPlugins) throws IOException {
        Environment env = TestEnvironment.newEnvironment(nodeSettings);
        AnalysisModule analysisModule = new AnalysisModule(env, Arrays.asList(analysisPlugins));
        AnalysisRegistry analysisRegistry = analysisModule.getAnalysisRegistry();
        return new TestAnalysis(analysisRegistry.build(indexSettings), analysisRegistry.buildTokenFilterFactories(indexSettings), analysisRegistry.buildTokenizerFactories(indexSettings), analysisRegistry.buildCharFilterFactories(indexSettings));
    }

    public static ScriptModule newTestScriptModule() {
        return new ScriptModule(Settings.EMPTY, Collections.singletonList(new ScriptPlugin(){

            public ScriptEngine getScriptEngine(Settings settings, Collection<ScriptContext<?>> contexts) {
                return new MockScriptEngine("mockscript", Collections.singletonMap("1", script -> "1"), Collections.emptyMap());
            }
        }));
    }

    public static IndicesModule newTestIndicesModule(final Map<String, Mapper.TypeParser> extraMappers, final Map<String, MetadataFieldMapper.TypeParser> extraMetadataMappers) {
        return new IndicesModule(Collections.singletonList(new MapperPlugin(){

            public Map<String, Mapper.TypeParser> getMappers() {
                return extraMappers;
            }

            public Map<String, MetadataFieldMapper.TypeParser> getMetadataMappers() {
                return extraMetadataMappers;
            }
        }));
    }

    public static boolean inFipsJvm() {
        return Security.getProviders()[0].getName().toLowerCase(Locale.ROOT).contains("fips");
    }

    private static /* synthetic */ void lambda$static$0(Appender leakAppender) {
        leakAppender.stop();
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configurator.shutdown((LoggerContext)context);
    }

    static {
        portGenerator = new AtomicInteger();
        nettyLoggedLeaks = new ArrayList<String>();
        ESTestCase.setTestSysProps();
        LogConfigurator.loadLog4jPlugins();
        String leakLoggerName = "io.netty.util.ResourceLeakDetector";
        Logger leakLogger = LogManager.getLogger((String)leakLoggerName);
        AbstractAppender leakAppender = new AbstractAppender(leakLoggerName, null, (Layout)PatternLayout.newBuilder().withPattern("%m").build()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void append(LogEvent event) {
                String message = event.getMessage().getFormattedMessage();
                if (Level.ERROR.equals((Object)event.getLevel()) && message.contains("LEAK:")) {
                    Collection collection = nettyLoggedLeaks;
                    synchronized (collection) {
                        nettyLoggedLeaks.add(message);
                    }
                }
            }
        };
        leakAppender.start();
        Loggers.addAppender((Logger)leakLogger, (Appender)leakAppender);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ESTestCase.lambda$static$0((Appender)leakAppender)));
        BootstrapForTesting.ensureInitialized();
        List jodaTZIds = DateTimeZone.getAvailableIDs().stream().filter(s -> !DateUtils.DEPRECATED_SHORT_TZ_IDS.contains(s)).sorted().collect(Collectors.toList());
        JODA_TIMEZONE_IDS = Collections.unmodifiableList(jodaTZIds);
        List<String> javaTZIds = Arrays.asList(TimeZone.getAvailableIDs());
        Collections.sort(javaTZIds);
        JAVA_TIMEZONE_IDS = Collections.unmodifiableList(javaTZIds);
        ArrayList<String> javaZoneIds = new ArrayList<String>(ZoneId.getAvailableZoneIds());
        Collections.sort(javaZoneIds);
        JAVA_ZONE_IDS = Collections.unmodifiableList(javaZoneIds);
        statusData = new ArrayList<StatusData>();
        StatusLogger.getLogger().setLevel(Level.WARN);
        StatusLogger.getLogger().registerListener((StatusListener)new StatusConsoleListener(Level.WARN){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void log(StatusData data) {
                List list = statusData;
                synchronized (list) {
                    statusData.add(data);
                }
            }
        });
        TIME_SUFFIXES = new String[]{"d", "h", "ms", "s", "m", "micros", "nanos"};
        geohashGenerator = new GeohashGenerator();
    }

    public static final class TestAnalysis {
        public final IndexAnalyzers indexAnalyzers;
        public final Map<String, TokenFilterFactory> tokenFilter;
        public final Map<String, TokenizerFactory> tokenizer;
        public final Map<String, CharFilterFactory> charFilter;

        public TestAnalysis(IndexAnalyzers indexAnalyzers, Map<String, TokenFilterFactory> tokenFilter, Map<String, TokenizerFactory> tokenizer, Map<String, CharFilterFactory> charFilter) {
            this.indexAnalyzers = indexAnalyzers;
            this.tokenFilter = tokenFilter;
            this.tokenizer = tokenizer;
            this.charFilter = charFilter;
        }
    }

    public static class GeohashGenerator
    extends CodepointSetGenerator {
        private static final char[] ASCII_SET = "0123456789bcdefghjkmnpqrstuvwxyz".toCharArray();

        public GeohashGenerator() {
            super(ASCII_SET);
        }
    }
}

