/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.test.rest.ESRestTestCase;

public final class Features {
    private static final List<String> SUPPORTED = Collections.unmodifiableList(Arrays.asList("catch_unauthorized", "embedded_stash_key", "headers", "node_selector", "stash_in_key", "stash_in_path", "stash_path_replace", "warnings", "yaml"));

    private Features() {
    }

    public static boolean areAllSupported(List<String> features) {
        try {
            for (String feature : features) {
                if (!(feature.equals("xpack") ? false == ESRestTestCase.hasXPack() : (feature.equals("no_xpack") ? ESRestTestCase.hasXPack() : false == SUPPORTED.contains(feature)))) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException("error checking if xpack is available", e);
        }
    }
}

