/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cli.SuppressForbidden;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.concurrent.CompletableContext;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.CancellableThreads;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.mocksocket.MockServerSocket;
import org.elasticsearch.mocksocket.MockSocket;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TcpServerChannel;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportSettings;

public class MockTcpTransport
extends TcpTransport {
    private static final Logger logger = LogManager.getLogger(MockTcpTransport.class);
    static final ConnectionProfile LIGHT_PROFILE;
    private final Set<MockChannel> openChannels = new HashSet<MockChannel>();
    private final ExecutorService executor;

    public MockTcpTransport(Settings settings, ThreadPool threadPool, BigArrays bigArrays, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        this(settings, threadPool, bigArrays, circuitBreakerService, namedWriteableRegistry, networkService, Version.CURRENT);
    }

    public MockTcpTransport(Settings settings, ThreadPool threadPool, BigArrays bigArrays, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService, Version mockVersion) {
        super("mock-tcp-transport", settings, mockVersion, threadPool, PageCacheRecycler.NON_RECYCLING_INSTANCE, circuitBreakerService, namedWriteableRegistry, networkService);
        this.executor = Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory((Settings)settings, (String)"__mock_network_thread"));
    }

    protected MockChannel bind(String name, InetSocketAddress address) throws IOException {
        MockServerSocket socket = new MockServerSocket();
        socket.setReuseAddress(((Boolean)TransportSettings.TCP_REUSE_ADDRESS.get(this.settings)).booleanValue());
        ByteSizeValue tcpReceiveBufferSize = (ByteSizeValue)TransportSettings.TCP_RECEIVE_BUFFER_SIZE.get(this.settings);
        if (tcpReceiveBufferSize.getBytes() > 0L) {
            socket.setReceiveBufferSize(tcpReceiveBufferSize.bytesAsInt());
        }
        socket.bind((SocketAddress)address);
        final MockChannel serverMockChannel = new MockChannel((ServerSocket)socket, name);
        final CountDownLatch started = new CountDownLatch(1);
        this.executor.execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                MockTcpTransport.this.onException(serverMockChannel, e);
            }

            protected void doRun() throws Exception {
                started.countDown();
                serverMockChannel.accept(MockTcpTransport.this.executor);
            }
        });
        try {
            started.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return serverMockChannel;
    }

    private void readMessage(MockChannel mockChannel, StreamInput input) throws IOException {
        Socket socket = mockChannel.activeChannel;
        byte[] minimalHeader = new byte[6];
        try {
            input.readFully(minimalHeader);
        }
        catch (EOFException eof) {
            throw new IOException("Connection reset by peer");
        }
        int msgSize = TcpTransport.readMessageLength((BytesReference)new BytesArray(minimalHeader));
        if (msgSize == -1) {
            socket.getOutputStream().flush();
        } else {
            byte[] buffer = new byte[msgSize];
            input.readFully(buffer);
            int expectedSize = 6 + msgSize;
            try (ReleasableBytesStreamOutput output = new ReleasableBytesStreamOutput(expectedSize, this.bigArrays);){
                output.write(minimalHeader);
                output.write(buffer);
                this.consumeNetworkReads(mockChannel, output.bytes());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressForbidden(reason="real socket for mocking remote connections")
    protected MockChannel initiateChannel(DiscoveryNode node) throws IOException {
        MockChannel channel;
        MockSocket socket;
        InetSocketAddress address;
        block3: {
            address = node.getAddress().address();
            socket = new MockSocket();
            channel = new MockChannel((Socket)socket, address, false, "none");
            boolean success = false;
            try {
                this.configureSocket((Socket)socket);
                success = true;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.close((Closeable[])new Closeable[]{socket});
                }
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{socket});
        }
        this.executor.submit(() -> {
            try {
                socket.connect((SocketAddress)address);
                socket.setSoLinger(false, 0);
                channel.connectFuture.complete(null);
                channel.loopRead(this.executor);
            }
            catch (Exception ex) {
                channel.connectFuture.completeExceptionally(ex);
            }
        });
        return channel;
    }

    protected ConnectionProfile maybeOverrideConnectionProfile(ConnectionProfile connectionProfile) {
        ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
        HashSet allTypesWithConnection = new HashSet();
        HashSet allTypesWithoutConnection = new HashSet();
        for (ConnectionProfile.ConnectionTypeHandle handle : connectionProfile.getHandles()) {
            Set types = handle.getTypes();
            if (handle.length > 0) {
                allTypesWithConnection.addAll(types);
                continue;
            }
            allTypesWithoutConnection.addAll(types);
        }
        builder.addConnections(1, allTypesWithConnection.toArray(new TransportRequestOptions.Type[0]));
        if (!allTypesWithoutConnection.isEmpty()) {
            builder.addConnections(0, allTypesWithoutConnection.toArray(new TransportRequestOptions.Type[0]));
        }
        builder.setHandshakeTimeout(connectionProfile.getHandshakeTimeout());
        builder.setConnectTimeout(connectionProfile.getConnectTimeout());
        builder.setPingInterval(connectionProfile.getPingInterval());
        builder.setCompressionEnabled(connectionProfile.getCompressionEnabled().booleanValue());
        return builder.build();
    }

    private void configureSocket(Socket socket) throws SocketException {
        ByteSizeValue tcpReceiveBufferSize;
        socket.setTcpNoDelay((Boolean)TransportSettings.TCP_NO_DELAY.get(this.settings));
        ByteSizeValue tcpSendBufferSize = (ByteSizeValue)TransportSettings.TCP_SEND_BUFFER_SIZE.get(this.settings);
        if (tcpSendBufferSize.getBytes() > 0L) {
            socket.setSendBufferSize(tcpSendBufferSize.bytesAsInt());
        }
        if ((tcpReceiveBufferSize = (ByteSizeValue)TransportSettings.TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
            socket.setReceiveBufferSize(tcpReceiveBufferSize.bytesAsInt());
        }
        socket.setReuseAddress((Boolean)TransportSettings.TCP_REUSE_ADDRESS.get(this.settings));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() {
        boolean success = false;
        try {
            if (((Boolean)NetworkService.NETWORK_SERVER.get(this.settings)).booleanValue()) {
                for (TcpTransport.ProfileSettings profileSettings : this.profileSettings) {
                    this.bindServer(profileSettings);
                }
            }
            super.doStart();
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopInternal() {
        ThreadPool.terminate((ExecutorService)this.executor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        Set<MockChannel> set = this.openChannels;
        synchronized (set) {
            assert (this.openChannels.isEmpty()) : "there are still open channels: " + this.openChannels;
        }
    }

    static {
        ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
        builder.addConnections(1, new TransportRequestOptions.Type[]{TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.PING, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.REG, TransportRequestOptions.Type.STATE});
        LIGHT_PROFILE = builder.build();
    }

    public final class MockChannel
    implements Closeable,
    TcpChannel,
    TcpServerChannel {
        private final AtomicBoolean isOpen = new AtomicBoolean(true);
        private final InetSocketAddress localAddress;
        private final ServerSocket serverSocket;
        private final Set<MockChannel> workerChannels = Collections.newSetFromMap(new ConcurrentHashMap());
        private final Socket activeChannel;
        private final boolean isServer;
        private final String profile;
        private final CancellableThreads cancellableThreads = new CancellableThreads();
        private final CompletableContext<Void> closeFuture = new CompletableContext();
        private final CompletableContext<Void> connectFuture = new CompletableContext();
        private final TcpChannel.ChannelStats stats = new TcpChannel.ChannelStats();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MockChannel(Socket socket, InetSocketAddress localAddress, boolean isServer, String profile) {
            this.localAddress = localAddress;
            this.activeChannel = socket;
            this.isServer = isServer;
            this.serverSocket = null;
            this.profile = profile;
            Set set = MockTcpTransport.this.openChannels;
            synchronized (set) {
                MockTcpTransport.this.openChannels.add(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MockChannel(ServerSocket serverSocket, String profile) {
            this.localAddress = (InetSocketAddress)serverSocket.getLocalSocketAddress();
            this.serverSocket = serverSocket;
            this.profile = profile;
            this.isServer = false;
            this.activeChannel = null;
            Set set = MockTcpTransport.this.openChannels;
            synchronized (set) {
                MockTcpTransport.this.openChannels.add(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accept(Executor executor) throws IOException {
            while (this.isOpen.get()) {
                Socket incomingSocket = this.serverSocket.accept();
                MockChannel incomingChannel = null;
                try {
                    MockTcpTransport.this.configureSocket(incomingSocket);
                    MockChannel mockChannel = this;
                    synchronized (mockChannel) {
                        if (this.isOpen.get()) {
                            InetSocketAddress localAddress = new InetSocketAddress(incomingSocket.getLocalAddress(), incomingSocket.getPort());
                            final MockChannel finalIncomingChannel = incomingChannel = new MockChannel(incomingSocket, localAddress, true, this.profile);
                            incomingChannel.addCloseListener(new ActionListener<Void>(){

                                public void onResponse(Void aVoid) {
                                    MockChannel.this.workerChannels.remove(finalIncomingChannel);
                                }

                                public void onFailure(Exception e) {
                                    MockChannel.this.workerChannels.remove(finalIncomingChannel);
                                }
                            });
                            MockTcpTransport.this.serverAcceptedChannel(incomingChannel);
                            this.workerChannels.add(incomingChannel);
                            incomingChannel.loopRead(executor);
                            incomingSocket = null;
                            incomingChannel = null;
                        }
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{incomingSocket, incomingChannel});
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{incomingSocket, incomingChannel});
            }
        }

        void loopRead(Executor executor) {
            executor.execute((Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    if (MockChannel.this.isOpen.get()) {
                        try {
                            MockTcpTransport.this.onException(MockChannel.this, e);
                        }
                        catch (Exception ex) {
                            logger.warn("failed on handling exception", (Throwable)ex);
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{MockChannel.this});
                        }
                    }
                }

                protected void doRun() throws Exception {
                    InputStreamStreamInput input = new InputStreamStreamInput((InputStream)new BufferedInputStream(MockChannel.this.activeChannel.getInputStream()));
                    while (MockChannel.this.isOpen.get() && !Thread.currentThread().isInterrupted()) {
                        MockChannel.this.cancellableThreads.executeIO(() -> this.lambda$doRun$0((StreamInput)input));
                    }
                }

                private /* synthetic */ void lambda$doRun$0(StreamInput input) throws IOException, InterruptedException {
                    MockTcpTransport.this.readMessage(MockChannel.this, input);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void close0() throws IOException {
            if (this.isOpen.compareAndSet(true, false)) {
                boolean removedChannel;
                Set set = MockTcpTransport.this.openChannels;
                synchronized (set) {
                    removedChannel = MockTcpTransport.this.openChannels.remove(this);
                }
                IOUtils.close((Closeable[])new Closeable[]{this.serverSocket, this.activeChannel, () -> IOUtils.close(this.workerChannels), () -> this.cancellableThreads.cancel("channel closed")});
                assert (removedChannel) : "Channel was not removed or removed twice?";
            }
        }

        public String toString() {
            return "MockChannel{profile='" + this.profile + '\'' + ", isOpen=" + this.isOpen + ", localAddress=" + this.localAddress + ", isServerSocket=" + (this.serverSocket != null) + '}';
        }

        @Override
        public void close() {
            try {
                this.close0();
                this.closeFuture.complete(null);
            }
            catch (IOException e) {
                this.closeFuture.completeExceptionally((Exception)e);
            }
        }

        public String getProfile() {
            return this.profile;
        }

        public boolean isServerChannel() {
            return this.isServer;
        }

        public void addCloseListener(ActionListener<Void> listener) {
            this.closeFuture.addListener(ActionListener.toBiConsumer(listener));
        }

        public void addConnectListener(ActionListener<Void> listener) {
            this.connectFuture.addListener(ActionListener.toBiConsumer(listener));
        }

        public TcpChannel.ChannelStats getChannelStats() {
            return this.stats;
        }

        public boolean isOpen() {
            return this.isOpen.get();
        }

        public InetSocketAddress getLocalAddress() {
            return this.localAddress;
        }

        public InetSocketAddress getRemoteAddress() {
            return (InetSocketAddress)this.activeChannel.getRemoteSocketAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMessage(BytesReference reference, ActionListener<Void> listener) {
            try {
                MockChannel mockChannel = this;
                synchronized (mockChannel) {
                    BufferedOutputStream outputStream = new BufferedOutputStream(this.activeChannel.getOutputStream());
                    reference.writeTo((OutputStream)outputStream);
                    ((OutputStream)outputStream).flush();
                }
                listener.onResponse(null);
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
                MockTcpTransport.this.onException(this, e);
            }
        }
    }
}

