/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.hbase;

import java.io.IOException;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseConnection {
    private static Logger LOGGER = LoggerFactory.getLogger(HBaseConnection.class);
    private Configuration config = null;

    public HBaseConnection() {
        this(true);
    }

    public HBaseConnection(String xmlConf, boolean checkConfig) {
        this.config = new Configuration(true);
        this.config.addResource(new Path(xmlConf));
        if (checkConfig) {
            this.checkHBaseConfiguration();
        }
    }

    public HBaseConnection(boolean checkConfig) {
        this("localhost", 2181, checkConfig);
    }

    public HBaseConnection(String zooKeeperQuorum, int zooKeeperClientPort, boolean checkConfig) {
        this.config = HBaseConfiguration.create();
        this.config.clear();
        this.config.set("hbase.zookeeper.quorum", zooKeeperQuorum);
        this.config.setInt("hbase.zookeeper.property.clientPort", zooKeeperClientPort);
        if (checkConfig) {
            this.checkHBaseConfiguration();
        }
    }

    public HBaseConnection(Configuration hbaseConf, boolean checkConfig) {
        this.config = hbaseConf;
        if (checkConfig) {
            this.checkHBaseConfiguration();
        }
    }

    public void checkHBaseConfiguration() {
        if (this.config == null) {
            throw new IllegalStateException("Connection has not been initialized");
        }
        try {
            HBaseAdmin.checkHBaseAvailable((Configuration)this.config);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot connect to server HBASE, please check /etc/hosts or settings.");
        }
    }

    public void createTable(String tableName, Set<String> columnFamilies) {
        try (Connection hbConn = ConnectionFactory.createConnection((Configuration)this.config);
             Admin hbAdmin = hbConn.getAdmin();){
            TableName hTableName = TableName.valueOf((String)tableName);
            if (!hbAdmin.tableExists(hTableName)) {
                HTableDescriptor tableDesc = new HTableDescriptor(hTableName);
                columnFamilies.stream().map(HColumnDescriptor::new).forEach(arg_0 -> ((HTableDescriptor)tableDesc).addFamily(arg_0));
                hbAdmin.createTable(tableDesc);
            } else {
                LOGGER.info("Table " + tableName + " already exists.");
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot create table " + tableName + " please check name", e);
        }
    }

    public void truncateTable(String tableName) {
        Connection hbConn = null;
        Admin hbAdmin = null;
        try {
            hbConn = ConnectionFactory.createConnection((Configuration)this.config);
            hbAdmin = hbConn.getAdmin();
            TableName target = TableName.valueOf((String)tableName);
            hbAdmin.disableTable(target);
            hbAdmin.truncateTable(target, false);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot truncate table " + tableName + " please check name", e);
        }
        finally {
            try {
                if (hbAdmin != null) {
                    hbAdmin.close();
                }
                if (hbConn != null) {
                    hbConn.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Exception decompiling
     */
    public Stream<String> listTablesName() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Configuration getConfig() {
        return this.config;
    }
}

