/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.hbase.mapper;

import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.ff4j.audit.Event;
import org.ff4j.hbase.HBaseConstants;
import org.ff4j.mapper.EventMapper;
import org.ff4j.utils.MappingUtil;

public class HBaseEventMapper
implements EventMapper<Put> {
    protected static final SimpleDateFormat KDF = new SimpleDateFormat("yyyyMMdd");

    public Put toStore(Event evt) {
        Put put = new Put(Bytes.toBytes((String)evt.getUuid()));
        put.addColumn(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_UID, Bytes.toBytes((String)evt.getUuid()));
        put.addColumn(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_SOURCE, Bytes.toBytes((String)evt.getSource()));
        put.addColumn(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_NAME, Bytes.toBytes((String)evt.getName()));
        put.addColumn(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_ACTION, Bytes.toBytes((String)evt.getAction()));
        put.addColumn(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_TYPE, Bytes.toBytes((String)evt.getType()));
        put.addColumn(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_DURATION, Bytes.toBytes((long)evt.getDuration()));
        put.addColumn(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_HOSTNAME, Bytes.toBytes((String)evt.getHostName()));
        put.addColumn(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_USER, Bytes.toBytes((String)evt.getUser()));
        put.addColumn(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_VALUE, Bytes.toBytes((String)evt.getValue()));
        put.addColumn(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_DATE, Bytes.toBytes((String)KDF.format(evt.getDate())));
        put.addColumn(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_TIME, Bytes.toBytes((long)evt.getTimestamp()));
        put.addColumn(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_KEYS, Bytes.toBytes((String)MappingUtil.fromMap((Map)evt.getCustomKeys())));
        return put;
    }

    public Event fromStore(Result result) {
        if (result == null) {
            return null;
        }
        Event evt = new Event();
        evt.setUuid(Bytes.toString((byte[])result.getValue(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_UID)));
        evt.setSource(Bytes.toString((byte[])result.getValue(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_SOURCE)));
        evt.setType(Bytes.toString((byte[])result.getValue(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_TYPE)));
        evt.setName(Bytes.toString((byte[])result.getValue(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_NAME)));
        evt.setAction(Bytes.toString((byte[])result.getValue(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_ACTION)));
        evt.setDuration(Bytes.toLong((byte[])result.getValue(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_DURATION)));
        evt.setHostName(Bytes.toString((byte[])result.getValue(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_HOSTNAME)));
        evt.setUser(Bytes.toString((byte[])result.getValue(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_USER)));
        evt.setValue(Bytes.toString((byte[])result.getValue(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_VALUE)));
        evt.setTimestamp(Bytes.toLong((byte[])result.getValue(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_TIME)));
        evt.setCustomKeys(MappingUtil.toMap((String)Bytes.toString((byte[])result.getValue(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_KEYS))));
        return evt;
    }

    public Event fromStore(Put bean) {
        throw new NotImplementedException("Data retrieved from HBASE are GET (not PUT)");
    }
}

