/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.hbase.mapper;

import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.ff4j.core.Feature;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.hbase.HBaseConstants;
import org.ff4j.mapper.FeatureMapper;
import org.ff4j.property.Property;
import org.ff4j.utils.JsonUtils;
import org.ff4j.utils.json.FeatureJsonParser;
import org.ff4j.utils.json.PropertyJsonParser;

public class HBaseFeatureMapper
implements FeatureMapper<Put> {
    public Put toStore(Feature fp) {
        Put put = new Put(Bytes.toBytes((String)fp.getUid()));
        put.addColumn(HBaseConstants.B_FEATURES_CF_CORE, HBaseConstants.B_FEAT_UID, Bytes.toBytes((String)fp.getUid()));
        byte[] desc = fp.getDescription() == null ? null : Bytes.toBytes((String)fp.getDescription());
        put.addColumn(HBaseConstants.B_FEATURES_CF_CORE, HBaseConstants.B_FEAT_DESCRIPTION, desc);
        put.addColumn(HBaseConstants.B_FEATURES_CF_CORE, HBaseConstants.B_FEAT_ENABLE, Bytes.toBytes((boolean)fp.isEnable()));
        byte[] group = fp.getGroup() == null ? null : Bytes.toBytes((String)fp.getGroup());
        put.addColumn(HBaseConstants.B_FEATURES_CF_CORE, HBaseConstants.B_FEAT_GROUPNAME, group);
        put.addColumn(HBaseConstants.B_FEATURES_CF_CORE, HBaseConstants.B_FEAT_ROLES, Bytes.toBytes((String)JsonUtils.permissionsAsJson((Set)fp.getPermissions())));
        put.addColumn(HBaseConstants.B_FEATURES_CF_CORE, HBaseConstants.B_FEAT_STRATEGY, Bytes.toBytes((String)JsonUtils.flippingStrategyAsJson((FlippingStrategy)fp.getFlippingStrategy())));
        if (fp.getCustomProperties() != null && !fp.getCustomProperties().isEmpty()) {
            for (Map.Entry customP : fp.getCustomProperties().entrySet()) {
                if (customP.getValue() == null) continue;
                put.addColumn(HBaseConstants.B_FEATURES_CF_PROPERTIES, Bytes.toBytes((String)((String)customP.getKey())), Bytes.toBytes((String)((Property)customP.getValue()).toJson()));
            }
        }
        return put;
    }

    public Feature fromStore(Put bean) {
        throw new NotImplementedException("Data retrieved from HBASE are GET (not PUT)");
    }

    public Feature fromStore(Result result) {
        String uid = Bytes.toString((byte[])result.getValue(HBaseConstants.B_FEATURES_CF_CORE, HBaseConstants.B_FEAT_UID));
        Feature fout = new Feature(uid);
        fout.setDescription(Bytes.toString((byte[])result.getValue(HBaseConstants.B_FEATURES_CF_CORE, HBaseConstants.B_FEAT_DESCRIPTION)));
        fout.setEnable(Bytes.toBoolean((byte[])result.getValue(HBaseConstants.B_FEATURES_CF_CORE, HBaseConstants.B_FEAT_ENABLE)));
        fout.setGroup(Bytes.toString((byte[])result.getValue(HBaseConstants.B_FEATURES_CF_CORE, HBaseConstants.B_FEAT_GROUPNAME)));
        if ("null".equals(fout.getGroup())) {
            fout.setGroup(null);
        }
        fout.setPermissions(FeatureJsonParser.parsePermissions((String)Bytes.toString((byte[])result.getValue(HBaseConstants.B_FEATURES_CF_CORE, HBaseConstants.B_FEAT_ROLES))));
        fout.setFlippingStrategy(FeatureJsonParser.parseFlipStrategyAsJson((String)uid, (String)Bytes.toString((byte[])result.getValue(HBaseConstants.B_FEATURES_CF_CORE, HBaseConstants.B_FEAT_STRATEGY))));
        NavigableMap map = result.getFamilyMap(HBaseConstants.B_FEATURES_CF_PROPERTIES);
        for (Map.Entry property : map.entrySet()) {
            fout.getCustomProperties().put(Bytes.toString((byte[])((byte[])property.getKey())), PropertyJsonParser.parseProperty((String)Bytes.toString((byte[])((byte[])property.getValue()))));
        }
        return fout;
    }
}

