/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.hbase.mapper;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.ff4j.hbase.HBaseConstants;
import org.ff4j.mapper.PropertyMapper;
import org.ff4j.property.Property;
import org.ff4j.property.util.PropertyFactory;
import org.ff4j.utils.JsonUtils;
import org.ff4j.utils.json.FeatureJsonParser;

public class HBasePropertyMapper
implements PropertyMapper<Put> {
    public Put toStore(Property<?> prop) {
        Put put = new Put(Bytes.toBytes((String)prop.getName()));
        byte[] propName = Bytes.toBytes((String)prop.getName());
        put.addColumn(HBaseConstants.B_FEATURES_CF_PROPERTIES, HBaseConstants.B_COL_PROPERTY_ID, propName);
        byte[] mytype = prop.getType() == null ? null : Bytes.toBytes((String)prop.getType());
        put.addColumn(HBaseConstants.B_FEATURES_CF_PROPERTIES, HBaseConstants.B_COL_PROPERTY_CLAZZ, mytype);
        byte[] pValue = prop.asString() == null ? null : Bytes.toBytes((String)prop.asString());
        put.addColumn(HBaseConstants.B_FEATURES_CF_PROPERTIES, HBaseConstants.B_COL_PROPERTY_VALUE, pValue);
        byte[] desc = prop.getDescription() == null ? null : Bytes.toBytes((String)prop.getDescription());
        put.addColumn(HBaseConstants.B_FEATURES_CF_PROPERTIES, HBaseConstants.B_COL_PROPERTY_DESCRIPTION, desc);
        HashSet<String> fixedValueAsString = new HashSet<String>();
        if (prop.getFixedValues() != null) {
            for (Object o : prop.getFixedValues()) {
                fixedValueAsString.add(o.toString());
            }
            byte[] pFixedValue = Bytes.toBytes((String)JsonUtils.permissionsAsJson(fixedValueAsString));
            put.addColumn(HBaseConstants.B_FEATURES_CF_PROPERTIES, HBaseConstants.B_COL_PROPERTY_FIXED, pFixedValue);
        }
        return put;
    }

    public Property<?> fromStore(Put bean) {
        throw new NotImplementedException("Data retrieved from HBASE are GET (not PUT)");
    }

    public Property<?> fromStore(Result result) {
        String propName = Bytes.toString((byte[])result.getValue(HBaseConstants.B_FEATURES_CF_PROPERTIES, HBaseConstants.B_COL_PROPERTY_ID));
        String propType = Bytes.toString((byte[])result.getValue(HBaseConstants.B_FEATURES_CF_PROPERTIES, HBaseConstants.B_COL_PROPERTY_CLAZZ));
        String propVal = Bytes.toString((byte[])result.getValue(HBaseConstants.B_FEATURES_CF_PROPERTIES, HBaseConstants.B_COL_PROPERTY_VALUE));
        Property prop = PropertyFactory.createProperty((String)propName, (String)propType, (String)propVal);
        String desc = Bytes.toString((byte[])result.getValue(HBaseConstants.B_FEATURES_CF_PROPERTIES, HBaseConstants.B_COL_PROPERTY_DESCRIPTION));
        prop.setDescription(desc);
        Set fixedValues = FeatureJsonParser.parsePermissions((String)Bytes.toString((byte[])result.getValue(HBaseConstants.B_FEATURES_CF_PROPERTIES, HBaseConstants.B_COL_PROPERTY_FIXED)));
        if (fixedValues != null) {
            fixedValues.forEach(arg_0 -> ((Property)prop).add2FixedValueFromString(arg_0));
        }
        return prop;
    }
}

