/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.hbase.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.ff4j.audit.Event;
import org.ff4j.audit.EventQueryDefinition;
import org.ff4j.audit.EventSeries;
import org.ff4j.audit.MutableHitCount;
import org.ff4j.audit.chart.TimeSeriesChart;
import org.ff4j.audit.repository.AbstractEventRepository;
import org.ff4j.exception.AuditAccessException;
import org.ff4j.hbase.HBaseConnection;
import org.ff4j.hbase.HBaseConstants;
import org.ff4j.hbase.mapper.HBaseEventMapper;
import org.ff4j.utils.Util;

public class EventRepositoryHBase
extends AbstractEventRepository {
    private static final HBaseEventMapper MAPPER = new HBaseEventMapper();
    private HBaseConnection conn;

    public EventRepositoryHBase() {
    }

    public EventRepositoryHBase(HBaseConnection conn) {
        this.conn = conn;
    }

    private void executePutCommand(Put putQuery) {
        try (Connection hbConn = ConnectionFactory.createConnection((Configuration)this.conn.getConfig());
             Table table = hbConn.getTable(HBaseConstants.AUDIT_TABLENAME);){
            table.put(putQuery);
        }
        catch (IOException e) {
            throw new AuditAccessException("Cannot execute command", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private Scan buildQuery(EventQueryDefinition qDef, Set<String> columnNames, String type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Filter createFilterListOR(byte[] columnName, Set<String> values) {
        FilterList filterOR = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        for (String actionValue : values) {
            filterOR.addFilter((Filter)new SingleColumnValueFilter(HBaseConstants.B_AUDIT_CF, columnName, CompareFilter.CompareOp.EQUAL, Bytes.toBytes((String)actionValue)));
        }
        return filterOR;
    }

    public void createSchema() {
        this.conn.createTable("ff4j_audit", Util.set((Object[])new String[]{"evt"}));
    }

    public boolean saveEvent(Event evt) {
        Util.assertEvent((Event)evt);
        this.executePutCommand(MAPPER.toStore(evt));
        return true;
    }

    /*
     * Exception decompiling
     */
    public Event getEventByUUID(String uuid, Long timestamp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Map<String, MutableHitCount> getFeatureUsageHitCount(EventQueryDefinition query) {
        return this.computeHitCount(query, "NAME");
    }

    public Map<String, MutableHitCount> getHostHitCount(EventQueryDefinition query) {
        return this.computeHitCount(query, "HOSTNAME");
    }

    public Map<String, MutableHitCount> getUserHitCount(EventQueryDefinition query) {
        return this.computeHitCount(query, "USER");
    }

    public Map<String, MutableHitCount> getSourceHitCount(EventQueryDefinition query) {
        return this.computeHitCount(query, "SOURCE");
    }

    private Map<String, MutableHitCount> computeHitCount(EventQueryDefinition query, String pColName) {
        HashMap<String, MutableHitCount> hitCount = new HashMap<String, MutableHitCount>();
        try (Connection hbConn = ConnectionFactory.createConnection((Configuration)this.conn.getConfig());
             Table table = hbConn.getTable(HBaseConstants.AUDIT_TABLENAME);){
            query.getActionFilters().add("checkOn");
            Scan scanQuery = this.buildQuery(query, Util.set((Object[])new String[]{pColName}), "feature");
            try (ResultScanner scanner = table.getScanner(scanQuery);){
                Result rr = scanner.next();
                while (rr != null) {
                    String colValue = Bytes.toString((byte[])rr.getValue(HBaseConstants.B_AUDIT_CF, Bytes.toBytes((String)pColName)));
                    if (hitCount.containsKey(colValue)) {
                        ((MutableHitCount)hitCount.get(colValue)).inc();
                    } else {
                        hitCount.put(colValue, new MutableHitCount(1));
                    }
                    rr = scanner.next();
                }
            }
        }
        catch (IOException e) {
            throw new AuditAccessException("Compute hitcount based on " + pColName, (Throwable)e);
        }
        return hitCount;
    }

    public TimeSeriesChart getFeatureUsageHistory(EventQueryDefinition query, TimeUnit units) {
        TimeSeriesChart tsc = new TimeSeriesChart(query.getFrom().longValue(), query.getTo().longValue(), units);
        Iterator iterEvent = this.searchFeatureUsageEvents(query).iterator();
        while (iterEvent.hasNext()) {
            tsc.addEvent((Event)iterEvent.next());
        }
        return tsc;
    }

    public EventSeries searchFeatureUsageEvents(EventQueryDefinition query) {
        EventSeries es = new EventSeries();
        try (Connection hbConn = ConnectionFactory.createConnection((Configuration)this.conn.getConfig());
             Table table = hbConn.getTable(HBaseConstants.AUDIT_TABLENAME);){
            query.getActionFilters().add("checkOn");
            Scan scanQuery = this.buildQuery(query, HBaseConstants.COLS_EVENT, "feature");
            try (ResultScanner scanner = table.getScanner(scanQuery);){
                Result rr = scanner.next();
                while (rr != null) {
                    es.add(MAPPER.fromStore(rr));
                    rr = scanner.next();
                }
            }
        }
        catch (IOException e) {
            throw new AuditAccessException("Cannot search feature usage ", (Throwable)e);
        }
        return es;
    }

    public EventSeries getAuditTrail(EventQueryDefinition query) {
        EventSeries es = new EventSeries();
        try (Connection hbConn = ConnectionFactory.createConnection((Configuration)this.conn.getConfig());
             Table table = hbConn.getTable(HBaseConstants.AUDIT_TABLENAME);){
            query.getActionFilters().add("checkOn");
            Scan scanQuery = this.buildQuery(query, HBaseConstants.COLS_EVENT, null);
            Set candidates = Util.set((Object[])new String[]{"disconnect", "toggle-on", "toggle-off", "create", "delete", "update", "clear"});
            try (ResultScanner scanner = table.getScanner(scanQuery);){
                Result rr = scanner.next();
                while (rr != null) {
                    String action = Bytes.toString((byte[])rr.getValue(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_ACTION));
                    if (candidates.contains(action)) {
                        es.add(MAPPER.fromStore(rr));
                    }
                    rr = scanner.next();
                }
            }
        }
        catch (IOException e) {
            throw new AuditAccessException("Cannot search audit trail ", (Throwable)e);
        }
        return es;
    }

    public void purgeFeatureUsage(EventQueryDefinition query) {
        this.purgeAuditTrail(query);
    }

    public void purgeAuditTrail(EventQueryDefinition query) {
        try (Connection hbConn = ConnectionFactory.createConnection((Configuration)this.conn.getConfig());
             Table table = hbConn.getTable(HBaseConstants.AUDIT_TABLENAME);){
            query.getActionFilters().add("checkOn");
            Scan scanQuery = this.buildQuery(query, Util.set((Object[])new String[]{"UID"}), null);
            ArrayList<Delete> list = new ArrayList<Delete>();
            try (ResultScanner scanner = table.getScanner(scanQuery);){
                Result rr = scanner.next();
                while (rr != null) {
                    list.add(new Delete(rr.getValue(HBaseConstants.B_AUDIT_CF, HBaseConstants.B_EVENT_UID)));
                    rr = scanner.next();
                }
            }
            table.delete(list);
        }
        catch (IOException e) {
            throw new AuditAccessException("Cannot search audit trail ", (Throwable)e);
        }
    }

    public HBaseConnection getConn() {
        return this.conn;
    }

    public void setConn(HBaseConnection conn) {
        this.conn = conn;
    }
}

