/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.hbase.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.ff4j.core.Feature;
import org.ff4j.exception.FeatureAccessException;
import org.ff4j.hbase.HBaseConnection;
import org.ff4j.hbase.HBaseConstants;
import org.ff4j.hbase.mapper.HBaseFeatureMapper;
import org.ff4j.store.AbstractFeatureStore;
import org.ff4j.utils.Util;

public class FeatureStoreHBase
extends AbstractFeatureStore {
    private static final HBaseFeatureMapper MAPPER = new HBaseFeatureMapper();
    private HBaseConnection conn;

    public FeatureStoreHBase() {
    }

    public FeatureStoreHBase(HBaseConnection conn) {
        this.conn = conn;
    }

    public void createSchema() {
        this.conn.createTable("ff4j_features", Util.set((Object[])new String[]{"f", "p"}));
    }

    /*
     * Exception decompiling
     */
    public boolean exist(String featId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void executePutCommand(Put putQuery) {
        try (Connection hbConn = ConnectionFactory.createConnection((Configuration)this.conn.getConfig());
             Table table = hbConn.getTable(HBaseConstants.FEATURES_TABLENAME);){
            table.put(putQuery);
        }
        catch (IOException e) {
            throw new FeatureAccessException("Cannot execute command", (Throwable)e);
        }
    }

    public void create(Feature fp) {
        this.assertFeatureNotNull(fp);
        this.assertFeatureNotExist(fp.getUid());
        this.executePutCommand(MAPPER.toStore(fp));
    }

    public void enable(String uid) {
        this.assertFeatureExist(uid);
        Put queryEnableFeature = new Put(Bytes.toBytes((String)uid));
        queryEnableFeature.addColumn(HBaseConstants.B_FEATURES_CF_CORE, HBaseConstants.B_FEAT_UID, Bytes.toBytes((String)uid));
        queryEnableFeature.addColumn(HBaseConstants.B_FEATURES_CF_CORE, HBaseConstants.B_FEAT_ENABLE, Bytes.toBytes((boolean)true));
        this.executePutCommand(queryEnableFeature);
    }

    public void disable(String uid) {
        this.assertFeatureExist(uid);
        Put queryDisableFeature = new Put(Bytes.toBytes((String)uid));
        queryDisableFeature.addColumn(HBaseConstants.B_FEATURES_CF_CORE, HBaseConstants.B_FEAT_UID, Bytes.toBytes((String)uid));
        queryDisableFeature.addColumn(HBaseConstants.B_FEATURES_CF_CORE, HBaseConstants.B_FEAT_ENABLE, Bytes.toBytes((boolean)false));
        this.executePutCommand(queryDisableFeature);
    }

    /*
     * Exception decompiling
     */
    public Feature read(String uid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Map<String, Feature> readAll() {
        HashMap<String, Feature> mapOfFeature = new HashMap<String, Feature>();
        try (Connection hbConn = ConnectionFactory.createConnection((Configuration)this.conn.getConfig());
             Table table = hbConn.getTable(HBaseConstants.FEATURES_TABLENAME);){
            Scan scan = new Scan();
            scan.setCaching(100);
            scan.setBatch(100);
            scan.addFamily(HBaseConstants.B_FEATURES_CF_CORE);
            scan.addFamily(HBaseConstants.B_FEATURES_CF_PROPERTIES);
            try (ResultScanner resultScanner = table.getScanner(scan);){
                Iterator iterator = resultScanner.iterator();
                while (iterator.hasNext()) {
                    Feature f = MAPPER.fromStore((Result)iterator.next());
                    mapOfFeature.put(f.getUid(), f);
                }
            }
        }
        catch (IOException e) {
            throw new FeatureAccessException("Cannot read all features", (Throwable)e);
        }
        return mapOfFeature;
    }

    public void delete(String uid) {
        this.assertFeatureExist(uid);
        try (Connection hbConn = ConnectionFactory.createConnection((Configuration)this.conn.getConfig());
             Table table = hbConn.getTable(HBaseConstants.FEATURES_TABLENAME);){
            ArrayList<Delete> list = new ArrayList<Delete>();
            Delete del = new Delete(uid.getBytes());
            list.add(del);
            table.delete(list);
        }
        catch (IOException e) {
            throw new FeatureAccessException("Cannot delete feature ", (Throwable)e);
        }
    }

    public void update(Feature fp) {
        this.assertFeatureNotNull(fp);
        this.assertFeatureExist(fp.getUid());
        this.delete(fp.getUid());
        this.create(fp);
    }

    public void clear() {
        this.conn.truncateTable("ff4j_features");
    }

    public HBaseConnection getConn() {
        return this.conn;
    }

    public void setConn(HBaseConnection conn) {
        this.conn = conn;
    }
}

