/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.hbase.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.ff4j.exception.PropertyAccessException;
import org.ff4j.hbase.HBaseConnection;
import org.ff4j.hbase.HBaseConstants;
import org.ff4j.hbase.mapper.HBasePropertyMapper;
import org.ff4j.property.Property;
import org.ff4j.property.store.AbstractPropertyStore;
import org.ff4j.utils.Util;

public class PropertyStoreHBase
extends AbstractPropertyStore {
    private static final HBasePropertyMapper MAPPER = new HBasePropertyMapper();
    private HBaseConnection conn;

    public PropertyStoreHBase() {
    }

    public PropertyStoreHBase(HBaseConnection conn) {
        this.conn = conn;
    }

    public void createSchema() {
        this.conn.createTable("ff4j_properties", Util.set((Object[])new String[]{"p"}));
    }

    /*
     * Exception decompiling
     */
    public boolean existProperty(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T> void createProperty(Property<T> prop) {
        this.assertPropertyNotNull(prop);
        this.assertPropertyNotExist(prop.getName());
        this.executePutCommand(MAPPER.toStore(prop));
    }

    /*
     * Exception decompiling
     */
    public Property<?> readProperty(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void deleteProperty(String name) {
        this.assertPropertyExist(name);
        try (Connection hbConn = ConnectionFactory.createConnection((Configuration)this.conn.getConfig());
             Table table = hbConn.getTable(HBaseConstants.PROPERTIES_TABLENAME);){
            ArrayList<Delete> list = new ArrayList<Delete>();
            Delete del = new Delete(name.getBytes());
            list.add(del);
            table.delete(list);
        }
        catch (IOException e) {
            throw new PropertyAccessException("Cannot delete property ", (Throwable)e);
        }
    }

    public Map<String, Property<?>> readAllProperties() {
        HashMap mapOfProperty = new HashMap();
        try (Connection hbConn = ConnectionFactory.createConnection((Configuration)this.conn.getConfig());
             Table table = hbConn.getTable(HBaseConstants.PROPERTIES_TABLENAME);){
            Scan scan = new Scan();
            scan.setCaching(100);
            scan.setBatch(100);
            scan.addFamily(HBaseConstants.B_FEATURES_CF_PROPERTIES);
            try (ResultScanner resultScanner = table.getScanner(scan);){
                Iterator iterator = resultScanner.iterator();
                while (iterator.hasNext()) {
                    Property<?> p = MAPPER.fromStore((Result)iterator.next());
                    mapOfProperty.put(p.getName(), p);
                }
            }
        }
        catch (IOException e) {
            throw new PropertyAccessException("Cannot read all property", (Throwable)e);
        }
        return mapOfProperty;
    }

    public Set<String> listPropertyNames() {
        return this.readAllProperties().keySet();
    }

    public void clear() {
        this.conn.truncateTable("ff4j_properties");
    }

    private void executePutCommand(Put putQuery) {
        try (Connection hbConn = ConnectionFactory.createConnection((Configuration)this.conn.getConfig());
             Table table = hbConn.getTable(HBaseConstants.PROPERTIES_TABLENAME);){
            table.put(putQuery);
        }
        catch (IOException e) {
            throw new PropertyAccessException("Cannot execute command", (Throwable)e);
        }
    }
}

