/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.console;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.messageresolver.MessageResolution;

public class CustomMessageResolver
implements IMessageResolver {
    private static final String MSG_FILE = "ff4j-messages";
    private static final String MSG_FILE_EXTENSION = ".properties";
    public static final Logger LOGGER = LoggerFactory.getLogger(CustomMessageResolver.class);
    protected Map<String, Properties> messages = new HashMap<String, Properties>();
    protected final Properties defaultMessages = new Properties();

    public void initialize() {
        try {
            this.defaultMessages.load(CustomMessageResolver.class.getClassLoader().getResourceAsStream("ff4j-messages.properties"));
        }
        catch (IOException e) {
            LOGGER.error("Cannot load properties", (Throwable)e);
        }
    }

    private Properties resolveProperties(Locale locale) {
        Properties target;
        if (!this.messages.containsKey(locale.getLanguage())) {
            String expectedFileName = "ff4j-messages_" + locale.getLanguage() + MSG_FILE_EXTENSION;
            InputStream is = CustomMessageResolver.class.getClassLoader().getResourceAsStream(expectedFileName);
            this.messages.put(locale.getLanguage(), null);
            if (is != null) {
                try {
                    Properties propsLocale = new Properties();
                    propsLocale.load(is);
                    this.messages.put(locale.getLanguage(), propsLocale);
                }
                catch (IOException e) {
                    LOGGER.error("Cannot load properties", (Throwable)e);
                }
            }
        }
        return (target = this.messages.get(locale.getLanguage())) != null ? target : this.defaultMessages;
    }

    public MessageResolution resolveMessage(Arguments args, String key, Object[] msgParams) {
        Locale locale = args.getContext().getLocale();
        String targetMsg = this.resolveProperties(locale).getProperty(key);
        if (targetMsg == null) {
            targetMsg = "<span style=\"color:red\">" + key + " not found</span>";
        } else if (msgParams != null && msgParams.length > 0) {
            targetMsg = new MessageFormat(targetMsg, args.getContext().getLocale()).format(msgParams);
        }
        return new MessageResolution(targetMsg);
    }

    public Integer getOrder() {
        return 0;
    }

    public String getName() {
        return "customMessageResolver";
    }
}

